/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.ConvertUtils;
import com.mapbox.mapboxsdk.plugins.annotation.Options;
import com.mapbox.mapboxsdk.plugins.annotation.Symbol;

public class SymbolOptions
extends Options<Symbol> {
    private boolean isDraggable;
    private Point geometry;
    private Float iconSize;
    private String iconImage;
    private Float iconRotate;
    private Float[] iconOffset;
    private String iconAnchor;
    private String textField;
    private String[] textFont;
    private Float textSize;
    private Float textMaxWidth;
    private Float textLetterSpacing;
    private String textJustify;
    private String textAnchor;
    private Float textRotate;
    private String textTransform;
    private Float[] textOffset;
    private Float iconOpacity;
    private String iconColor;
    private String iconHaloColor;
    private Float iconHaloWidth;
    private Float iconHaloBlur;
    private Float textOpacity;
    private String textColor;
    private String textHaloColor;
    private Float textHaloWidth;
    private Float textHaloBlur;
    private int zIndex;

    public SymbolOptions withIconSize(Float iconSize) {
        this.iconSize = iconSize;
        return this;
    }

    public Float getIconSize() {
        return this.iconSize;
    }

    public SymbolOptions withIconImage(String iconImage) {
        this.iconImage = iconImage;
        return this;
    }

    public String getIconImage() {
        return this.iconImage;
    }

    public SymbolOptions withIconRotate(Float iconRotate) {
        this.iconRotate = iconRotate;
        return this;
    }

    public Float getIconRotate() {
        return this.iconRotate;
    }

    public SymbolOptions withIconOffset(Float[] iconOffset) {
        this.iconOffset = iconOffset;
        return this;
    }

    public Float[] getIconOffset() {
        return this.iconOffset;
    }

    public SymbolOptions withIconAnchor(String iconAnchor) {
        this.iconAnchor = iconAnchor;
        return this;
    }

    public String getIconAnchor() {
        return this.iconAnchor;
    }

    public SymbolOptions withTextField(String textField) {
        this.textField = textField;
        return this;
    }

    public String getTextField() {
        return this.textField;
    }

    public SymbolOptions withTextFont(String[] textFont) {
        this.textFont = textFont;
        return this;
    }

    public String[] getTextFont() {
        return this.textFont;
    }

    public SymbolOptions withTextSize(Float textSize) {
        this.textSize = textSize;
        return this;
    }

    public Float getTextSize() {
        return this.textSize;
    }

    public SymbolOptions withTextMaxWidth(Float textMaxWidth) {
        this.textMaxWidth = textMaxWidth;
        return this;
    }

    public Float getTextMaxWidth() {
        return this.textMaxWidth;
    }

    public SymbolOptions withTextLetterSpacing(Float textLetterSpacing) {
        this.textLetterSpacing = textLetterSpacing;
        return this;
    }

    public Float getTextLetterSpacing() {
        return this.textLetterSpacing;
    }

    public SymbolOptions withTextJustify(String textJustify) {
        this.textJustify = textJustify;
        return this;
    }

    public String getTextJustify() {
        return this.textJustify;
    }

    public SymbolOptions withTextAnchor(String textAnchor) {
        this.textAnchor = textAnchor;
        return this;
    }

    public String getTextAnchor() {
        return this.textAnchor;
    }

    public SymbolOptions withTextRotate(Float textRotate) {
        this.textRotate = textRotate;
        return this;
    }

    public Float getTextRotate() {
        return this.textRotate;
    }

    public SymbolOptions withTextTransform(String textTransform) {
        this.textTransform = textTransform;
        return this;
    }

    public String getTextTransform() {
        return this.textTransform;
    }

    public SymbolOptions withTextOffset(Float[] textOffset) {
        this.textOffset = textOffset;
        return this;
    }

    public Float[] getTextOffset() {
        return this.textOffset;
    }

    public SymbolOptions withIconOpacity(Float iconOpacity) {
        this.iconOpacity = iconOpacity;
        return this;
    }

    public Float getIconOpacity() {
        return this.iconOpacity;
    }

    public SymbolOptions withIconColor(String iconColor) {
        this.iconColor = iconColor;
        return this;
    }

    public String getIconColor() {
        return this.iconColor;
    }

    public SymbolOptions withIconHaloColor(String iconHaloColor) {
        this.iconHaloColor = iconHaloColor;
        return this;
    }

    public String getIconHaloColor() {
        return this.iconHaloColor;
    }

    public SymbolOptions withIconHaloWidth(Float iconHaloWidth) {
        this.iconHaloWidth = iconHaloWidth;
        return this;
    }

    public Float getIconHaloWidth() {
        return this.iconHaloWidth;
    }

    public SymbolOptions withIconHaloBlur(Float iconHaloBlur) {
        this.iconHaloBlur = iconHaloBlur;
        return this;
    }

    public Float getIconHaloBlur() {
        return this.iconHaloBlur;
    }

    public SymbolOptions withTextOpacity(Float textOpacity) {
        this.textOpacity = textOpacity;
        return this;
    }

    public Float getTextOpacity() {
        return this.textOpacity;
    }

    public SymbolOptions withTextColor(String textColor) {
        this.textColor = textColor;
        return this;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public SymbolOptions withTextHaloColor(String textHaloColor) {
        this.textHaloColor = textHaloColor;
        return this;
    }

    public String getTextHaloColor() {
        return this.textHaloColor;
    }

    public SymbolOptions withTextHaloWidth(Float textHaloWidth) {
        this.textHaloWidth = textHaloWidth;
        return this;
    }

    public Float getTextHaloWidth() {
        return this.textHaloWidth;
    }

    public SymbolOptions withTextHaloBlur(Float textHaloBlur) {
        this.textHaloBlur = textHaloBlur;
        return this;
    }

    public Float getTextHaloBlur() {
        return this.textHaloBlur;
    }

    public SymbolOptions withLatLng(LatLng latLng) {
        this.geometry = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
        return this;
    }

    public SymbolOptions withGeometry(Point geometry) {
        this.geometry = geometry;
        return this;
    }

    public SymbolOptions withZIndex(int zIndex) {
        this.zIndex = zIndex;
        return this;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public SymbolOptions setDraggable(boolean draggable) {
        this.isDraggable = draggable;
        return this;
    }

    @Override
    Symbol build(long id, AnnotationManager<?, Symbol, ?, ?, ?, ?> annotationManager) {
        if (this.geometry == null) {
            throw new RuntimeException("geometry field is required");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("icon-size", (Number)this.iconSize);
        jsonObject.addProperty("icon-image", this.iconImage);
        jsonObject.addProperty("icon-rotate", (Number)this.iconRotate);
        jsonObject.add("icon-offset", (JsonElement)ConvertUtils.convertArray(this.iconOffset));
        jsonObject.addProperty("icon-anchor", this.iconAnchor);
        jsonObject.addProperty("text-field", this.textField);
        jsonObject.add("text-font", (JsonElement)ConvertUtils.convertArray(this.textFont));
        jsonObject.addProperty("text-size", (Number)this.textSize);
        jsonObject.addProperty("text-max-width", (Number)this.textMaxWidth);
        jsonObject.addProperty("text-letter-spacing", (Number)this.textLetterSpacing);
        jsonObject.addProperty("text-justify", this.textJustify);
        jsonObject.addProperty("text-anchor", this.textAnchor);
        jsonObject.addProperty("text-rotate", (Number)this.textRotate);
        jsonObject.addProperty("text-transform", this.textTransform);
        jsonObject.add("text-offset", (JsonElement)ConvertUtils.convertArray(this.textOffset));
        jsonObject.addProperty("icon-opacity", (Number)this.iconOpacity);
        jsonObject.addProperty("icon-color", this.iconColor);
        jsonObject.addProperty("icon-halo-color", this.iconHaloColor);
        jsonObject.addProperty("icon-halo-width", (Number)this.iconHaloWidth);
        jsonObject.addProperty("icon-halo-blur", (Number)this.iconHaloBlur);
        jsonObject.addProperty("text-opacity", (Number)this.textOpacity);
        jsonObject.addProperty("text-color", this.textColor);
        jsonObject.addProperty("text-halo-color", this.textHaloColor);
        jsonObject.addProperty("text-halo-width", (Number)this.textHaloWidth);
        jsonObject.addProperty("text-halo-blur", (Number)this.textHaloBlur);
        jsonObject.addProperty("z-index", (Number)this.zIndex);
        Symbol symbol = new Symbol(id, annotationManager, jsonObject, this.geometry);
        symbol.setDraggable(this.isDraggable);
        return symbol;
    }

    @Nullable
    static SymbolOptions fromFeature(@NonNull Feature feature) {
        if (feature.geometry() == null) {
            throw new RuntimeException("geometry field is required");
        }
        if (!(feature.geometry() instanceof Point)) {
            return null;
        }
        SymbolOptions options = new SymbolOptions();
        options.geometry = (Point)feature.geometry();
        if (feature.hasProperty("icon-size")) {
            options.iconSize = Float.valueOf(feature.getProperty("icon-size").getAsFloat());
        }
        if (feature.hasProperty("icon-image")) {
            options.iconImage = feature.getProperty("icon-image").getAsString();
        }
        if (feature.hasProperty("icon-rotate")) {
            options.iconRotate = Float.valueOf(feature.getProperty("icon-rotate").getAsFloat());
        }
        if (feature.hasProperty("icon-offset")) {
            options.iconOffset = ConvertUtils.toFloatArray(feature.getProperty("icon-offset").getAsJsonArray());
        }
        if (feature.hasProperty("icon-anchor")) {
            options.iconAnchor = feature.getProperty("icon-anchor").getAsString();
        }
        if (feature.hasProperty("text-field")) {
            options.textField = feature.getProperty("text-field").getAsString();
        }
        if (feature.hasProperty("text-font")) {
            options.textFont = ConvertUtils.toStringArray(feature.getProperty("text-font").getAsJsonArray());
        }
        if (feature.hasProperty("text-size")) {
            options.textSize = Float.valueOf(feature.getProperty("text-size").getAsFloat());
        }
        if (feature.hasProperty("text-max-width")) {
            options.textMaxWidth = Float.valueOf(feature.getProperty("text-max-width").getAsFloat());
        }
        if (feature.hasProperty("text-letter-spacing")) {
            options.textLetterSpacing = Float.valueOf(feature.getProperty("text-letter-spacing").getAsFloat());
        }
        if (feature.hasProperty("text-justify")) {
            options.textJustify = feature.getProperty("text-justify").getAsString();
        }
        if (feature.hasProperty("text-anchor")) {
            options.textAnchor = feature.getProperty("text-anchor").getAsString();
        }
        if (feature.hasProperty("text-rotate")) {
            options.textRotate = Float.valueOf(feature.getProperty("text-rotate").getAsFloat());
        }
        if (feature.hasProperty("text-transform")) {
            options.textTransform = feature.getProperty("text-transform").getAsString();
        }
        if (feature.hasProperty("text-offset")) {
            options.textOffset = ConvertUtils.toFloatArray(feature.getProperty("text-offset").getAsJsonArray());
        }
        if (feature.hasProperty("icon-opacity")) {
            options.iconOpacity = Float.valueOf(feature.getProperty("icon-opacity").getAsFloat());
        }
        if (feature.hasProperty("icon-color")) {
            options.iconColor = feature.getProperty("icon-color").getAsString();
        }
        if (feature.hasProperty("icon-halo-color")) {
            options.iconHaloColor = feature.getProperty("icon-halo-color").getAsString();
        }
        if (feature.hasProperty("icon-halo-width")) {
            options.iconHaloWidth = Float.valueOf(feature.getProperty("icon-halo-width").getAsFloat());
        }
        if (feature.hasProperty("icon-halo-blur")) {
            options.iconHaloBlur = Float.valueOf(feature.getProperty("icon-halo-blur").getAsFloat());
        }
        if (feature.hasProperty("text-opacity")) {
            options.textOpacity = Float.valueOf(feature.getProperty("text-opacity").getAsFloat());
        }
        if (feature.hasProperty("text-color")) {
            options.textColor = feature.getProperty("text-color").getAsString();
        }
        if (feature.hasProperty("text-halo-color")) {
            options.textHaloColor = feature.getProperty("text-halo-color").getAsString();
        }
        if (feature.hasProperty("text-halo-width")) {
            options.textHaloWidth = Float.valueOf(feature.getProperty("text-halo-width").getAsFloat());
        }
        if (feature.hasProperty("text-halo-blur")) {
            options.textHaloBlur = Float.valueOf(feature.getProperty("text-halo-blur").getAsFloat());
        }
        if (feature.hasProperty("z-index")) {
            options.zIndex = feature.getProperty("z-index").getAsInt();
        }
        if (feature.hasProperty("is-draggable")) {
            options.isDraggable = feature.getProperty("is-draggable").getAsBoolean();
        }
        return options;
    }
}

