/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.CoreElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.DraggableAnnotationController;
import com.mapbox.mapboxsdk.plugins.annotation.Fill;
import com.mapbox.mapboxsdk.plugins.annotation.FillOptions;
import com.mapbox.mapboxsdk.plugins.annotation.OnFillClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnFillDragListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnFillLongClickListener;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.FillLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import java.util.ArrayList;
import java.util.List;

public class FillManager
extends AnnotationManager<FillLayer, Fill, FillOptions, OnFillDragListener, OnFillClickListener, OnFillLongClickListener> {
    public static final String ID_GEOJSON_SOURCE = "mapbox-android-fill-source";
    public static final String ID_GEOJSON_LAYER = "mapbox-android-fill-layer";

    @UiThread
    public FillManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style) {
        this(mapView, mapboxMap, style, null);
    }

    @UiThread
    public FillManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @Nullable String belowLayerId) {
        this(mapView, mapboxMap, style, new CoreElementProvider<FillLayer>(){

            @Override
            public FillLayer getLayer() {
                return new FillLayer(FillManager.ID_GEOJSON_LAYER, FillManager.ID_GEOJSON_SOURCE);
            }

            @Override
            public GeoJsonSource getSource() {
                return new GeoJsonSource(FillManager.ID_GEOJSON_SOURCE);
            }
        }, belowLayerId, new DraggableAnnotationController<Fill, OnFillDragListener>(mapView, mapboxMap));
    }

    @VisibleForTesting
    public FillManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @NonNull CoreElementProvider<FillLayer> coreElementProvider, @Nullable String belowLayerId, DraggableAnnotationController<Fill, OnFillDragListener> draggableAnnotationController) {
        super(mapView, mapboxMap, style, coreElementProvider, null, draggableAnnotationController, belowLayerId);
    }

    @Override
    void initializeDataDrivenPropertyMap() {
        this.dataDrivenPropertyUsageMap.put("fill-opacity", false);
        this.dataDrivenPropertyUsageMap.put("fill-color", false);
        this.dataDrivenPropertyUsageMap.put("fill-outline-color", false);
        this.dataDrivenPropertyUsageMap.put("fill-pattern", false);
    }

    @Override
    protected void setDataDrivenPropertyIsUsed(@NonNull String property) {
        switch (property) {
            case "fill-opacity": {
                ((FillLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.fillOpacity((Expression)Expression.get((String)"fill-opacity"))});
                break;
            }
            case "fill-color": {
                ((FillLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.fillColor((Expression)Expression.get((String)"fill-color"))});
                break;
            }
            case "fill-outline-color": {
                ((FillLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.fillOutlineColor((Expression)Expression.get((String)"fill-outline-color"))});
                break;
            }
            case "fill-pattern": {
                ((FillLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.fillPattern((Expression)Expression.get((String)"fill-pattern"))});
            }
        }
    }

    @Override
    @UiThread
    public List<Fill> create(@NonNull String json) {
        return this.create(FeatureCollection.fromJson((String)json));
    }

    @Override
    @UiThread
    public List<Fill> create(@NonNull FeatureCollection featureCollection) {
        List features = featureCollection.features();
        ArrayList<FillOptions> options = new ArrayList<FillOptions>();
        if (features != null) {
            for (Feature feature : features) {
                FillOptions option = FillOptions.fromFeature(feature);
                if (option == null) continue;
                options.add(option);
            }
        }
        return this.create(options);
    }

    @Override
    String getAnnotationLayerId() {
        return ID_GEOJSON_LAYER;
    }

    @Override
    String getAnnotationIdKey() {
        return "id";
    }

    public Boolean getFillAntialias() {
        return (Boolean)((FillLayer)this.layer).getFillAntialias().value;
    }

    public void setFillAntialias(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.fillAntialias((Boolean)value);
        this.constantPropertyUsageMap.put("fill-antialias", propertyValue);
        ((FillLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float[] getFillTranslate() {
        return (Float[])((FillLayer)this.layer).getFillTranslate().value;
    }

    public void setFillTranslate(Float[] value) {
        PropertyValue propertyValue = PropertyFactory.fillTranslate((Float[])value);
        this.constantPropertyUsageMap.put("fill-translate", propertyValue);
        ((FillLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getFillTranslateAnchor() {
        return (String)((FillLayer)this.layer).getFillTranslateAnchor().value;
    }

    public void setFillTranslateAnchor(String value) {
        PropertyValue propertyValue = PropertyFactory.fillTranslateAnchor((String)value);
        this.constantPropertyUsageMap.put("fill-translate-anchor", propertyValue);
        ((FillLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    @Override
    public void setFilter(@NonNull Expression expression) {
        this.layerFilter = expression;
        ((FillLayer)this.layer).setFilter(this.layerFilter);
    }

    @Nullable
    public Expression getFilter() {
        return ((FillLayer)this.layer).getFilter();
    }
}

