/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.ArrayList;
import java.util.List;

@UiThread
public class Fill
extends Annotation<Polygon> {
    private final AnnotationManager<?, Fill, ?, ?, ?, ?> annotationManager;

    Fill(long id, AnnotationManager<?, Fill, ?, ?, ?, ?> annotationManager, JsonObject jsonObject, Polygon geometry) {
        super(id, jsonObject, geometry);
        this.annotationManager = annotationManager;
    }

    @Override
    void setUsedDataDrivenProperties() {
        if (!(this.jsonObject.get("fill-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("fill-opacity");
        }
        if (!(this.jsonObject.get("fill-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("fill-color");
        }
        if (!(this.jsonObject.get("fill-outline-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("fill-outline-color");
        }
        if (!(this.jsonObject.get("fill-pattern") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("fill-pattern");
        }
    }

    public void setLatLngs(List<List<LatLng>> latLngs) {
        ArrayList points = new ArrayList();
        for (List<LatLng> innerLatLngs : latLngs) {
            ArrayList<Point> innerList = new ArrayList<Point>();
            for (LatLng latLng : innerLatLngs) {
                innerList.add(Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude()));
            }
            points.add(innerList);
        }
        this.geometry = Polygon.fromLngLats(points);
    }

    @NonNull
    public List<List<LatLng>> getLatLngs() {
        Polygon polygon = (Polygon)this.geometry;
        ArrayList<List<LatLng>> latLngs = new ArrayList<List<LatLng>>();
        List coordinates = polygon.coordinates();
        if (coordinates != null) {
            for (List innerPoints : coordinates) {
                ArrayList<LatLng> innerList = new ArrayList<LatLng>();
                for (Point point : innerPoints) {
                    innerList.add(new LatLng(point.latitude(), point.longitude()));
                }
                latLngs.add(innerList);
            }
        }
        return latLngs;
    }

    public Float getFillOpacity() {
        return Float.valueOf(this.jsonObject.get("fill-opacity").getAsFloat());
    }

    public void setFillOpacity(Float value) {
        this.jsonObject.addProperty("fill-opacity", (Number)value);
    }

    @ColorInt
    public int getFillColor() {
        return ColorUtils.rgbaToColor((String)this.jsonObject.get("fill-color").getAsString());
    }

    public void setFillColor(@ColorInt int color) {
        this.jsonObject.addProperty("fill-color", ColorUtils.colorToRgbaString((int)color));
    }

    @ColorInt
    public int getFillOutlineColor() {
        return ColorUtils.rgbaToColor((String)this.jsonObject.get("fill-outline-color").getAsString());
    }

    public void setFillOutlineColor(@ColorInt int color) {
        this.jsonObject.addProperty("fill-outline-color", ColorUtils.colorToRgbaString((int)color));
    }

    public String getFillPattern() {
        return this.jsonObject.get("fill-pattern").getAsString();
    }

    public void setFillPattern(String value) {
        this.jsonObject.addProperty("fill-pattern", value);
    }

    @Override
    @Nullable
    Geometry getOffsetGeometry(@NonNull Projection projection, @NonNull MoveDistancesObject moveDistancesObject, float touchAreaShiftX, float touchAreaShiftY) {
        List originalPoints = ((Polygon)this.geometry).coordinates();
        if (originalPoints != null) {
            ArrayList resultingPoints = new ArrayList(originalPoints.size());
            for (List points : originalPoints) {
                ArrayList<Point> innerPoints = new ArrayList<Point>();
                for (Point jsonPoint : points) {
                    PointF pointF = projection.toScreenLocation(new LatLng(jsonPoint.latitude(), jsonPoint.longitude()));
                    pointF.x -= moveDistancesObject.getDistanceXSinceLast();
                    pointF.y -= moveDistancesObject.getDistanceYSinceLast();
                    LatLng latLng = projection.fromScreenLocation(pointF);
                    if (latLng.getLatitude() > 85.05112877980659 || latLng.getLatitude() < -85.05112877980659) {
                        return null;
                    }
                    innerPoints.add(Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude()));
                }
                resultingPoints.add(innerPoints);
            }
            return Polygon.fromLngLats(resultingPoints);
        }
        return null;
    }
}

