/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.maps.Projection;

public abstract class Annotation<T extends Geometry> {
    static final String ID_KEY = "id";
    protected JsonObject jsonObject;
    protected T geometry;
    private boolean isDraggable;

    Annotation(long id, JsonObject jsonObject, T geometry) {
        this.jsonObject = jsonObject;
        this.jsonObject.addProperty(ID_KEY, (Number)id);
        this.geometry = geometry;
    }

    public void setGeometry(T geometry) {
        this.geometry = geometry;
    }

    public T getGeometry() {
        if (this.geometry == null) {
            throw new IllegalStateException();
        }
        return this.geometry;
    }

    public long getId() {
        return this.jsonObject.get(ID_KEY).getAsLong();
    }

    JsonObject getFeature() {
        return this.jsonObject;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public void setDraggable(boolean draggable) {
        this.isDraggable = draggable;
    }

    @Nullable
    abstract Geometry getOffsetGeometry(@NonNull Projection var1, @NonNull MoveDistancesObject var2, float var3, float var4);

    abstract void setUsedDataDrivenProperties();
}

