/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import androidx.core.view.GestureDetectorCompat;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashSet;
import java.util.Set;

@UiThread
public class StandardScaleGestureDetector
extends ProgressiveGesture<StandardOnScaleGestureListener> {
    private static final Set<Integer> handledTypes = new HashSet<Integer>();
    private static final float QUICK_SCALE_MULTIPLIER = 0.5f;
    private final GestureDetectorCompat innerGestureDetector;
    private boolean quickScale;
    private PointF quickScaleFocalPoint;
    private float startSpan;
    private float startSpanX;
    private float startSpanY;
    private float currentSpan;
    private float currentSpanX;
    private float currentSpanY;
    private float previousSpan;
    private float previousSpanX;
    private float previousSpanY;
    private float spanDeltaSinceStart;
    private float spanSinceStartThreshold;
    private boolean isScalingOut;
    private float scaleFactor;

    public StandardScaleGestureDetector(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
        GestureDetector.SimpleOnGestureListener doubleTapEventListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTapEvent(MotionEvent event) {
                if (event.getActionMasked() == 0) {
                    StandardScaleGestureDetector.this.quickScale = true;
                    StandardScaleGestureDetector.this.quickScaleFocalPoint = new PointF(event.getX(), event.getY());
                }
                return true;
            }
        };
        this.innerGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)doubleTapEventListener);
    }

    @Override
    protected boolean analyzeMovement() {
        super.analyzeMovement();
        if (this.isInProgress() && this.quickScale && this.getPointersCount() > 1) {
            this.gestureStopped();
            return false;
        }
        PointF focal = this.quickScale ? this.quickScaleFocalPoint : this.getFocalPoint();
        this.currentSpanX = 0.0f;
        this.currentSpanY = 0.0f;
        for (int i = 0; i < this.getPointersCount(); ++i) {
            this.currentSpanX += Math.abs(this.getCurrentEvent().getX(i) - focal.x);
            this.currentSpanY += Math.abs(this.getCurrentEvent().getY(i) - focal.y);
        }
        this.currentSpanX *= 2.0f;
        this.currentSpanY *= 2.0f;
        this.currentSpan = this.quickScale ? this.currentSpanY : (float)Math.hypot(this.currentSpanX, this.currentSpanY);
        if (this.startSpan == 0.0f) {
            this.startSpan = this.currentSpan;
            this.startSpanX = this.currentSpanX;
            this.startSpanY = this.currentSpanY;
        }
        this.spanDeltaSinceStart = Math.abs(this.startSpan - this.currentSpan);
        this.scaleFactor = this.calculateScaleFactor();
        this.isScalingOut = this.scaleFactor < 1.0f;
        boolean handled = false;
        if (this.isInProgress() && this.currentSpan > 0.0f) {
            handled = ((StandardOnScaleGestureListener)this.listener).onScale(this);
        } else if (this.canExecute(this.quickScale ? 15 : 1) && this.spanDeltaSinceStart >= this.spanSinceStartThreshold && (handled = ((StandardOnScaleGestureListener)this.listener).onScaleBegin(this))) {
            this.gestureStarted();
        }
        this.previousSpan = this.currentSpan;
        this.previousSpanX = this.currentSpanX;
        this.previousSpanY = this.currentSpanY;
        return handled;
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        ((StandardOnScaleGestureListener)this.listener).onScaleEnd(this, this.velocityX, this.velocityY);
        this.quickScale = false;
    }

    @Override
    protected void reset() {
        super.reset();
        this.startSpan = 0.0f;
        this.spanDeltaSinceStart = 0.0f;
        this.currentSpan = 0.0f;
        this.previousSpan = 0.0f;
        this.scaleFactor = 1.0f;
    }

    @Override
    protected boolean analyzeEvent(@NonNull MotionEvent motionEvent) {
        int action = motionEvent.getActionMasked();
        if (this.quickScale) {
            if (action == 5 || action == 3) {
                if (this.isInProgress()) {
                    this.interrupt();
                } else {
                    this.quickScale = false;
                }
            } else if (!this.isInProgress() && action == 1) {
                this.quickScale = false;
            }
        }
        boolean handled = super.analyzeEvent(motionEvent);
        return handled | this.innerGestureDetector.onTouchEvent(motionEvent);
    }

    @Override
    protected int getRequiredPointersCount() {
        if (this.isInProgress()) {
            return this.quickScale ? 1 : 2;
        }
        return 1;
    }

    @Override
    protected boolean isSloppyGesture() {
        return super.isSloppyGesture() || !this.quickScale && this.getPointersCount() < 2;
    }

    @Override
    @NonNull
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    public boolean isScalingOut() {
        return this.isScalingOut;
    }

    public float getSpanSinceStartThreshold() {
        return this.spanSinceStartThreshold;
    }

    public void setSpanSinceStartThreshold(float spanSinceStartThreshold) {
        this.spanSinceStartThreshold = spanSinceStartThreshold;
    }

    public void setSpanSinceStartThresholdResource(@DimenRes int spanSinceStartThresholdDimen) {
        this.setSpanSinceStartThreshold(this.context.getResources().getDimension(spanSinceStartThresholdDimen));
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public float getStartSpan() {
        return this.startSpan;
    }

    public float getStartSpanX() {
        return this.startSpanX;
    }

    public float getStartSpanY() {
        return this.startSpanY;
    }

    public float getCurrentSpan() {
        return this.currentSpan;
    }

    public float getCurrentSpanX() {
        return this.currentSpanX;
    }

    public float getCurrentSpanY() {
        return this.currentSpanY;
    }

    public float getPreviousSpan() {
        return this.previousSpan;
    }

    public float getPreviousSpanX() {
        return this.previousSpanX;
    }

    public float getPreviousSpanY() {
        return this.previousSpanY;
    }

    private float calculateScaleFactor() {
        if (this.quickScale) {
            boolean scaleOut = this.getCurrentEvent().getY() < this.quickScaleFocalPoint.y && this.currentSpan < this.previousSpan || this.getCurrentEvent().getY() > this.quickScaleFocalPoint.y && this.currentSpan > this.previousSpan;
            float spanDiff = Math.abs(1.0f - this.currentSpan / this.previousSpan) * 0.5f;
            return this.previousSpan <= 0.0f ? 1.0f : (scaleOut ? 1.0f + spanDiff : 1.0f - spanDiff);
        }
        return this.previousSpan > 0.0f ? this.currentSpan / this.previousSpan : 1.0f;
    }

    static {
        handledTypes.add(1);
        handledTypes.add(15);
    }

    public static class SimpleStandardOnScaleGestureListener
    implements StandardOnScaleGestureListener {
        @Override
        public boolean onScaleBegin(@NonNull StandardScaleGestureDetector detector) {
            return true;
        }

        @Override
        public boolean onScale(@NonNull StandardScaleGestureDetector detector) {
            return false;
        }

        @Override
        public void onScaleEnd(@NonNull StandardScaleGestureDetector detector, float velocityX, float velocityY) {
        }
    }

    public static interface StandardOnScaleGestureListener {
        public boolean onScaleBegin(@NonNull StandardScaleGestureDetector var1);

        public boolean onScale(@NonNull StandardScaleGestureDetector var1);

        public void onScaleEnd(@NonNull StandardScaleGestureDetector var1, float var2, float var3);
    }
}

