/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import androidx.annotation.IntRange;

class PermittedActionsGuard {
    private static final int BITS_PER_PERMITTED_ACTION = 8;
    private static final int PERMITTED_ACTION_MASK = 255;
    private static final int NO_ACTION_PERMITTED = 255;

    PermittedActionsGuard() {
    }

    boolean isMissingActions(int action, @IntRange(from=0L) int eventPointerCount, @IntRange(from=0L) int internalPointerCount) {
        long permittedActions = this.updatePermittedActions(eventPointerCount, internalPointerCount);
        if ((long)action == permittedActions) {
            return false;
        }
        while (permittedActions != 0L) {
            long testCase = permittedActions & 0xFFL;
            if ((long)action == testCase) {
                return false;
            }
            permittedActions >>= 8;
        }
        return true;
    }

    private long updatePermittedActions(@IntRange(from=0L) int eventPointerCount, @IntRange(from=0L) int internalPointerCount) {
        long permittedActions = 0L;
        if (internalPointerCount == 0) {
            permittedActions <<= 8;
            permittedActions += 0L;
        } else {
            if (Math.abs(eventPointerCount - internalPointerCount) > 1) {
                return 255L;
            }
            if (eventPointerCount > internalPointerCount) {
                permittedActions <<= 8;
                permittedActions += 5L;
            } else {
                if (eventPointerCount < internalPointerCount) {
                    return 255L;
                }
                if (eventPointerCount == 1) {
                    permittedActions <<= 8;
                    ++permittedActions;
                } else {
                    permittedActions <<= 8;
                    permittedActions += 6L;
                }
                permittedActions <<= 8;
                permittedActions += 2L;
            }
        }
        return permittedActions;
    }
}

