/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.BaseGesture;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.PermittedActionsGuard;
import com.mapbox.android.gestures.PointerDistancePair;
import com.mapbox.android.gestures.ProgressiveGesture;
import com.mapbox.android.gestures.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;

@UiThread
public abstract class MultiFingerGesture<L>
extends BaseGesture<L> {
    private static final float PRESSURE_THRESHOLD = 0.67f;
    private static final int DEFAULT_REQUIRED_FINGERS_COUNT = 2;
    private final float edgeSlop;
    private float spanThreshold;
    private final PermittedActionsGuard permittedActionsGuard = new PermittedActionsGuard();
    final List<Integer> pointerIdList = new ArrayList<Integer>();
    final HashMap<PointerDistancePair, MultiFingerDistancesObject> pointersDistanceMap = new HashMap();
    private PointF focalPoint = new PointF();
    private DisplayMetrics displayMetrics;

    public MultiFingerGesture(Context context, AndroidGesturesManager gesturesManager) {
        super(context, gesturesManager);
        ViewConfiguration config = ViewConfiguration.get((Context)context);
        this.edgeSlop = config.getScaledEdgeSlop();
        this.queryDisplayMetrics();
    }

    @Override
    protected boolean analyzeEvent(@NonNull MotionEvent motionEvent) {
        boolean isMissingEvents;
        int action = motionEvent.getActionMasked();
        if (action == 0) {
            this.queryDisplayMetrics();
        }
        boolean bl = isMissingEvents = this.permittedActionsGuard.isMissingActions(action, motionEvent.getPointerCount(), this.pointerIdList.size()) || action == 2 && this.isMissingPointers(motionEvent);
        if (isMissingEvents) {
            if (this instanceof ProgressiveGesture && ((ProgressiveGesture)this).isInProgress()) {
                ((ProgressiveGesture)this).gestureStopped();
            }
            this.pointerIdList.clear();
            this.pointersDistanceMap.clear();
        }
        if (!isMissingEvents || action == 0) {
            this.updatePointerList(motionEvent);
        }
        this.focalPoint = Utils.determineFocalPoint(motionEvent);
        if (isMissingEvents) {
            Log.w((String)"MultiFingerGesture", (String)"Some MotionEvents were not passed to the library or events from different view trees are merged.");
            return false;
        }
        if (action == 2 && this.pointerIdList.size() >= this.getRequiredPointersCount() && this.checkPressure()) {
            this.calculateDistances();
            if (!this.isSloppyGesture()) {
                return this.analyzeMovement();
            }
        }
        return false;
    }

    private void queryDisplayMetrics() {
        if (this.windowManager != null) {
            this.displayMetrics = new DisplayMetrics();
            Display display = this.windowManager.getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealMetrics(this.displayMetrics);
            } else {
                display.getMetrics(this.displayMetrics);
            }
        } else {
            this.displayMetrics = this.context.getResources().getDisplayMetrics();
        }
    }

    private void updatePointerList(MotionEvent motionEvent) {
        int action = motionEvent.getActionMasked();
        if (action == 0 || action == 5) {
            this.pointerIdList.add(motionEvent.getPointerId(motionEvent.getActionIndex()));
        } else if (action == 1 || action == 6) {
            this.pointerIdList.remove((Object)motionEvent.getPointerId(motionEvent.getActionIndex()));
        }
    }

    private boolean isMissingPointers(MotionEvent motionEvent) {
        for (int pointerId : this.pointerIdList) {
            boolean hasPointer = motionEvent.findPointerIndex(pointerId) != -1;
            if (hasPointer) continue;
            return true;
        }
        return false;
    }

    boolean checkPressure() {
        float previousPressure;
        float currentPressure = this.getCurrentEvent().getPressure();
        return currentPressure / (previousPressure = this.getPreviousEvent().getPressure()) > 0.67f;
    }

    private boolean checkSpanBelowThreshold() {
        for (MultiFingerDistancesObject distancesObject : this.pointersDistanceMap.values()) {
            if (!(distancesObject.getCurrFingersDiffXY() < this.spanThreshold)) continue;
            return true;
        }
        return false;
    }

    protected int getRequiredPointersCount() {
        return 2;
    }

    protected boolean analyzeMovement() {
        return false;
    }

    protected boolean isSloppyGesture() {
        float rightSlopEdge = (float)this.displayMetrics.widthPixels - this.edgeSlop;
        float bottomSlopEdge = (float)this.displayMetrics.heightPixels - this.edgeSlop;
        float edgeSlop = this.edgeSlop;
        for (int pointerId : this.pointerIdList) {
            int pointerIndex = this.getCurrentEvent().findPointerIndex(pointerId);
            float x = Utils.getRawX(this.getCurrentEvent(), pointerIndex);
            float y = Utils.getRawY(this.getCurrentEvent(), pointerIndex);
            boolean isSloppy = x < edgeSlop || y < edgeSlop || x > rightSlopEdge || y > bottomSlopEdge;
            if (!isSloppy) continue;
            return true;
        }
        return this.checkSpanBelowThreshold();
    }

    @Override
    protected boolean canExecute(int invokedGestureType) {
        return super.canExecute(invokedGestureType) && !this.isSloppyGesture();
    }

    protected void reset() {
    }

    private void calculateDistances() {
        this.pointersDistanceMap.clear();
        for (int i = 0; i < this.pointerIdList.size() - 1; ++i) {
            for (int j = i + 1; j < this.pointerIdList.size(); ++j) {
                int primaryPointerId = this.pointerIdList.get(i);
                int secondaryPointerId = this.pointerIdList.get(j);
                float px0 = this.getPreviousEvent().getX(this.getPreviousEvent().findPointerIndex(primaryPointerId));
                float py0 = this.getPreviousEvent().getY(this.getPreviousEvent().findPointerIndex(primaryPointerId));
                float px1 = this.getPreviousEvent().getX(this.getPreviousEvent().findPointerIndex(secondaryPointerId));
                float py1 = this.getPreviousEvent().getY(this.getPreviousEvent().findPointerIndex(secondaryPointerId));
                float prevFingersDiffX = px1 - px0;
                float prevFingersDiffY = py1 - py0;
                float cx0 = this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(primaryPointerId));
                float cy0 = this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(primaryPointerId));
                float cx1 = this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(secondaryPointerId));
                float cy1 = this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(secondaryPointerId));
                float currFingersDiffX = cx1 - cx0;
                float currFingersDiffY = cy1 - cy0;
                this.pointersDistanceMap.put(new PointerDistancePair(primaryPointerId, secondaryPointerId), new MultiFingerDistancesObject(prevFingersDiffX, prevFingersDiffY, currFingersDiffX, currFingersDiffY));
            }
        }
    }

    public float getCurrentSpan(int firstPointerIndex, int secondPointerIndex) {
        if (!this.verifyPointers(firstPointerIndex, secondPointerIndex)) {
            throw new NoSuchElementException("There is no such pair of pointers!");
        }
        MultiFingerDistancesObject distancesObject = this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(firstPointerIndex), this.pointerIdList.get(secondPointerIndex)));
        return distancesObject.getCurrFingersDiffXY();
    }

    public float getPreviousSpan(int firstPointerIndex, int secondPointerIndex) {
        if (!this.verifyPointers(firstPointerIndex, secondPointerIndex)) {
            throw new NoSuchElementException("There is no such pair of pointers!");
        }
        MultiFingerDistancesObject distancesObject = this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(firstPointerIndex), this.pointerIdList.get(secondPointerIndex)));
        return distancesObject.getPrevFingersDiffXY();
    }

    public float getCurrentSpanX(int firstPointerIndex, int secondPointerIndex) {
        if (!this.verifyPointers(firstPointerIndex, secondPointerIndex)) {
            throw new NoSuchElementException("There is no such pair of pointers!");
        }
        MultiFingerDistancesObject distancesObject = this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(firstPointerIndex), this.pointerIdList.get(secondPointerIndex)));
        return Math.abs(distancesObject.getCurrFingersDiffX());
    }

    public float getCurrentSpanY(int firstPointerIndex, int secondPointerIndex) {
        if (!this.verifyPointers(firstPointerIndex, secondPointerIndex)) {
            throw new NoSuchElementException("There is no such pair of pointers!");
        }
        MultiFingerDistancesObject distancesObject = this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(firstPointerIndex), this.pointerIdList.get(secondPointerIndex)));
        return Math.abs(distancesObject.getCurrFingersDiffY());
    }

    public float getPreviousSpanX(int firstPointerIndex, int secondPointerIndex) {
        if (!this.verifyPointers(firstPointerIndex, secondPointerIndex)) {
            throw new NoSuchElementException("There is no such pair of pointers!");
        }
        MultiFingerDistancesObject distancesObject = this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(firstPointerIndex), this.pointerIdList.get(secondPointerIndex)));
        return Math.abs(distancesObject.getPrevFingersDiffX());
    }

    public float getPreviousSpanY(int firstPointerIndex, int secondPointerIndex) {
        if (!this.verifyPointers(firstPointerIndex, secondPointerIndex)) {
            throw new NoSuchElementException("There is no such pair of pointers!");
        }
        MultiFingerDistancesObject distancesObject = this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(firstPointerIndex), this.pointerIdList.get(secondPointerIndex)));
        return Math.abs(distancesObject.getPrevFingersDiffY());
    }

    private boolean verifyPointers(int firstPointerIndex, int secondPointerIndex) {
        return firstPointerIndex != secondPointerIndex && firstPointerIndex >= 0 && secondPointerIndex >= 0 && firstPointerIndex < this.getPointersCount() && secondPointerIndex < this.getPointersCount();
    }

    public int getPointersCount() {
        return this.pointerIdList.size();
    }

    public PointF getFocalPoint() {
        return this.focalPoint;
    }

    public float getSpanThreshold() {
        return this.spanThreshold;
    }

    public void setSpanThreshold(float spanThreshold) {
        this.spanThreshold = spanThreshold;
    }

    public void setSpanThresholdResource(@DimenRes int spanThresholdDimen) {
        this.setSpanThreshold(this.context.getResources().getDimension(spanThresholdDimen));
    }
}

