/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geocoder;

import android.util.Log;
import com.mapbox.geocoder.service.GeocoderService;
import com.mapbox.geocoder.service.models.GeocoderResponse;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import retrofit.Call;
import retrofit.Callback;
import retrofit.Converter;
import retrofit.GsonConverterFactory;
import retrofit.Retrofit;

public class MapboxGeocoder {
    private static final String LOG_TAG = "MapboxGeocoder";
    private static final String BASE_URL = "https://api.mapbox.com";
    private Call<GeocoderResponse> _call;

    public MapboxGeocoder(Builder builder) {
        GeocoderService service = this.getService();
        this._call = service.geocode(builder._geocodingDataset, builder._query, builder._accessToken, builder._proximity, builder._geocodingType);
    }

    public retrofit.Response<GeocoderResponse> execute() throws IOException {
        return this._call.execute();
    }

    public void enqueue(Callback<GeocoderResponse> callback) {
        this._call.enqueue(callback);
    }

    public void cancel() {
        this._call.cancel();
    }

    public Call<GeocoderResponse> clone() {
        return this._call.clone();
    }

    GeocoderService getService() {
        OkHttpClient client = new OkHttpClient();
        client.interceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Log.d((String)MapboxGeocoder.LOG_TAG, (String)String.format("Mapbox URL: %s", request.url()));
                Response response = chain.proceed(request);
                return response;
            }
        });
        Retrofit retrofit = new Retrofit.Builder().client(client).baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        GeocoderService service = (GeocoderService)retrofit.create(GeocoderService.class);
        return service;
    }

    public static class Builder {
        private String _accessToken;
        private String _query;
        private String _geocodingDataset = "mapbox.places";
        private String _proximity = null;
        private String _geocodingType = null;

        public Builder setAccessToken(String accessToken) {
            this._accessToken = accessToken;
            return this;
        }

        public Builder setDataset(String geocodingDataset) {
            this._geocodingDataset = geocodingDataset;
            return this;
        }

        public Builder setLocation(String location) {
            this._query = location;
            return this;
        }

        public Builder setCoordinates(double longitude, double latitude) {
            this._query = String.format("%f,%f", longitude, latitude);
            return this;
        }

        public Builder setProximity(double longitude, double latitude) {
            this._proximity = String.format("%f,%f", longitude, latitude);
            return this;
        }

        public Builder setType(String geocodingType) {
            this._geocodingType = geocodingType;
            return this;
        }

        public MapboxGeocoder build() {
            return new MapboxGeocoder(this);
        }
    }
}

