/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.liquibase.sqlgenerators;

import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.MarkChangeSetRanStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtils;

public class PortofinoPostgresMarkChangeSetRanGenerator
extends AbstractSqlGenerator<MarkChangeSetRanStatement> {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";

    public int getPriority() {
        return 5;
    }

    public boolean supports(MarkChangeSetRanStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(MarkChangeSetRanStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("changeSet", (Object)statement.getChangeSet());
        return validationErrors;
    }

    public Sql[] generateSql(MarkChangeSetRanStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        UpdateStatement runStatement;
        String dateValue = database.getCurrentDateTimeFunction();
        ChangeSet changeSet = statement.getChangeSet();
        try {
            if (statement.getExecType().equals((Object)ChangeSet.ExecType.FAILED) || statement.getExecType().equals((Object)ChangeSet.ExecType.SKIPPED)) {
                return new Sql[0];
            }
            if (statement.getExecType().ranBefore) {
                runStatement = new UpdateStatement(database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName()).addNewColumnValue("dateexecuted", (Object)new DatabaseFunction(dateValue)).addNewColumnValue("md5sum", (Object)changeSet.generateCheckSum().toString()).addNewColumnValue("exectype", (Object)statement.getExecType().value).setWhereClause("id=? AND author=? AND filename=?").addWhereParameters(new Object[]{changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()});
            } else {
                Change change;
                runStatement = new InsertStatement(database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName()).addColumnValue("id", (Object)changeSet.getId()).addColumnValue("author", (Object)changeSet.getAuthor()).addColumnValue("filename", (Object)changeSet.getFilePath()).addColumnValue("dateexecuted", (Object)new DatabaseFunction(dateValue)).addColumnValue("orderexecuted", (Object)database.getNextChangeSetSequenceValue()).addColumnValue("md5sum", (Object)changeSet.generateCheckSum().toString()).addColumnValue("description", (Object)this.limitSize(changeSet.getDescription())).addColumnValue("comments", (Object)this.limitSize(StringUtils.trimToEmpty((String)changeSet.getComments()))).addColumnValue("exectype", (Object)statement.getExecType().value).addColumnValue("liquibase", (Object)LiquibaseUtil.getBuildVersion().replaceAll("SNAPSHOT", "SNP"));
                String tag = null;
                List changes = changeSet.getChanges();
                if (changes != null && changes.size() == 1 && (change = (Change)changes.get(0)) instanceof TagDatabaseChange) {
                    TagDatabaseChange tagChange = (TagDatabaseChange)change;
                    tag = tagChange.getTag();
                }
                if (tag != null) {
                    ((InsertStatement)runStatement).addColumnValue("TAG", tag);
                }
            }
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        return SqlGeneratorFactory.getInstance().generateSql((SqlStatement)runStatement, database);
    }

    private String limitSize(String string) {
        int maxLength = 255;
        if (string.length() > maxLength) {
            return string.substring(0, maxLength - 3) + "...";
        }
        return string;
    }
}

