/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.portofino.PortofinoProperties;
import com.manydesigns.portofino.database.platforms.GoogleCloudSQLDatabasePlatform;
import com.manydesigns.portofino.liquibase.databases.GoogleCloudSQLDatabase;
import com.manydesigns.portofino.liquibase.sqlgenerators.GoogleCloudSQLLockDatabaseChangeLogGenerator;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatform;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleStatus;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GooglecloudsqlModule
implements Module {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    @Autowired
    public Configuration configuration;
    @Autowired
    DatabasePlatformsRegistry databasePlatformsRegistry;
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final Logger logger = LoggerFactory.getLogger(GooglecloudsqlModule.class);

    public String getModuleVersion() {
        return PortofinoProperties.getPortofinoVersion();
    }

    public String getName() {
        return "Google Cloud SQL";
    }

    @PostConstruct
    public void init() {
        if (this.configuration.getBoolean("liquibase.enabled", true)) {
            logger.debug("Registering Google Cloud SQL");
            DatabaseFactory.getInstance().register((Database)new GoogleCloudSQLDatabase());
            logger.debug("Registering GoogleCloudSQLLockDatabaseChangeLogGenerator");
            SqlGeneratorFactory.getInstance().register((SqlGenerator)new GoogleCloudSQLLockDatabaseChangeLogGenerator());
        }
        this.databasePlatformsRegistry.addDatabasePlatform((DatabasePlatform)new GoogleCloudSQLDatabasePlatform());
        this.status = ModuleStatus.STARTED;
    }

    @PreDestroy
    public void destroy() {
        this.status = ModuleStatus.DESTROYED;
    }

    public ModuleStatus getStatus() {
        return this.status;
    }
}

