/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.code.AggregateCodeBase;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.config.ConfigurationSource;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleStatus;
import com.manydesigns.portofino.persistence.Persistence;
import com.manydesigns.portofino.persistence.hibernate.multitenancy.MultiTenancyImplementation;
import com.manydesigns.portofino.persistence.hibernate.multitenancy.MultiTenancyImplementationFactory;
import io.reactivex.disposables.Disposable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.hibernate.EntityMode;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.ContextRefreshedEvent;

public class DatabaseModule
implements Module,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String GENERATED_CLASSES_DIRECTORY_NAME = "classes-generated";
    @Autowired
    public ServletContext servletContext;
    @Autowired
    public ConfigurationSource configuration;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.application.directory")
    public FileObject applicationDirectory;
    protected ApplicationContext applicationContext;
    protected ModuleStatus status = ModuleStatus.CREATED;
    protected final AggregateCodeBase persistenceCodeBase = new AggregateCodeBase(null, this.getClass().getClassLoader());
    protected Disposable subscription;
    public static final String LIQUIBASE_ENABLED = "liquibase.enabled";
    public static final Logger logger = LoggerFactory.getLogger(DatabaseModule.class);

    public String getModuleVersion() {
        return Module.getPortofinoVersion();
    }

    public String getName() {
        return "Database";
    }

    @PostConstruct
    public void init() {
        this.status = ModuleStatus.ACTIVE;
    }

    @Autowired
    public void setCodeBase(CodeBase codeBase) throws Exception {
        codeBase.setParent((CodeBase)this.persistenceCodeBase);
    }

    @Bean
    public DatabasePlatformsRegistry getDatabasePlatformsRegistry() {
        return new DatabasePlatformsRegistry(this.configuration.getProperties());
    }

    @Bean
    public MultiTenancyImplementationFactory getApplicationContextMTImplFactory() {
        return implClass -> {
            try {
                return (MultiTenancyImplementation)((Object)((Object)this.applicationContext.getBean(implClass)));
            }
            catch (BeansException e) {
                logger.error("MultiTenancyImplementation is not a valid spring bean, trying default constructor");
                return MultiTenancyImplementationFactory.DEFAULT.make(implClass);
            }
        };
    }

    @Bean
    public Persistence getPersistence(@Autowired DatabasePlatformsRegistry databasePlatformsRegistry, @Autowired CacheResetListenerRegistry cacheResetListenerRegistry) throws FileSystemException {
        Persistence persistence = new Persistence(this.applicationDirectory, this.configuration, databasePlatformsRegistry);
        persistence.cacheResetListenerRegistry = cacheResetListenerRegistry;
        if (this.applicationContext != null) {
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)persistence);
        }
        FileObject generatedClassesRoot = this.applicationDirectory.resolveFile(GENERATED_CLASSES_DIRECTORY_NAME);
        generatedClassesRoot.createFolder();
        AllFileSelector allFileSelector = new AllFileSelector();
        this.subscription = persistence.databaseSetupEvents.subscribe(e -> {
            String databaseName = e.setup.getDatabase().getDatabaseName();
            FileObject inMemoryDatabaseDir = e.setup.getCodeBase().getRoot().resolveFile(databaseName);
            FileObject externalDatabaseDir = generatedClassesRoot.resolveFile(databaseName);
            externalDatabaseDir.deleteAll();
            switch (e.type) {
                case 1: {
                    this.persistenceCodeBase.add(e.setup.getCodeBase());
                    if (e.setup.getEntityMode() != EntityMode.POJO) break;
                    externalDatabaseDir.copyFrom(inMemoryDatabaseDir, (FileSelector)allFileSelector);
                    break;
                }
                case -1: {
                    this.persistenceCodeBase.remove(e.setup.getCodeBase());
                    externalDatabaseDir.deleteAll();
                    inMemoryDatabaseDir.deleteAll();
                    break;
                }
                case 0: {
                    this.persistenceCodeBase.replace(e.oldSetup.getCodeBase(), e.setup.getCodeBase());
                    externalDatabaseDir.deleteAll();
                    if (e.setup.getEntityMode() != EntityMode.POJO) break;
                    externalDatabaseDir.copyFrom(inMemoryDatabaseDir, (FileSelector)allFileSelector);
                }
            }
        });
        return persistence;
    }

    @PreDestroy
    public void destroy() {
        logger.info("ManyDesigns Portofino database module stopping...");
        ((Persistence)this.applicationContext.getBean(Persistence.class)).stop();
        if (this.subscription != null) {
            this.subscription.dispose();
            this.subscription = null;
        }
        logger.info("ManyDesigns Portofino database module stopped.");
        this.status = ModuleStatus.DESTROYED;
    }

    public ModuleStatus getStatus() {
        return this.status;
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(@NotNull ContextRefreshedEvent event) {
        Persistence persistence = (Persistence)this.applicationContext.getBean(Persistence.class);
        Persistence.Status status = (Persistence.Status)((Object)persistence.status.getValue());
        if (status == null || status == Persistence.Status.STOPPED) {
            logger.info("Starting persistence...");
            persistence.start();
            this.status = ModuleStatus.STARTED;
            logger.info("Persistence started.");
        }
    }
}

