/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence.hibernate.multitenancy;

import com.manydesigns.portofino.persistence.hibernate.multitenancy.MultiTenancyImplementation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.jetbrains.annotations.NotNull;

public abstract class SchemaBasedMultiTenancy
extends MultiTenancyImplementation {
    @Override
    public MultiTenancyStrategy getStrategy() {
        return MultiTenancyStrategy.SCHEMA;
    }

    @Override
    @NotNull
    protected ConnectionProvider createConnectionProvider(String tenant, Map configuration) {
        ConnectionProvider delegate = super.createConnectionProvider(tenant, configuration);
        return new ConnectionProviderWithSchemaPerTenant(delegate, tenant);
    }

    protected abstract void setSchema(Connection var1, String var2) throws SQLException;

    public class ConnectionProviderWithSchemaPerTenant
    implements ConnectionProvider {
        private final ConnectionProvider delegate;
        private final String tenant;

        public ConnectionProviderWithSchemaPerTenant(ConnectionProvider delegate, String tenant) {
            this.delegate = delegate;
            this.tenant = tenant;
        }

        public Connection getConnection() throws SQLException {
            Connection connection = this.delegate.getConnection();
            SchemaBasedMultiTenancy.this.setSchema(connection, this.tenant);
            return connection;
        }

        public void closeConnection(Connection conn) throws SQLException {
            this.delegate.closeConnection(conn);
        }

        public boolean supportsAggressiveRelease() {
            return this.delegate.supportsAggressiveRelease();
        }

        public boolean isUnwrappableAs(Class unwrapType) {
            return this.delegate.isUnwrappableAs(unwrapType);
        }

        public <T> T unwrap(Class<T> unwrapType) {
            return (T)this.delegate.unwrap(unwrapType);
        }
    }
}

