/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence;

import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.text.OgnlTextFormat;
import com.manydesigns.elements.text.TextFormat;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdStrategy {
    protected final ClassAccessor classAccessor;

    public IdStrategy(ClassAccessor classAccessor) {
        this.classAccessor = classAccessor;
    }

    public abstract Object getPrimaryKey(String ... var1);

    public String[] generatePkStringArray(Object object) {
        PropertyAccessor[] keyProperties = this.classAccessor.getKeyProperties();
        String[] array = new String[keyProperties.length];
        for (int i = 0; i < keyProperties.length; ++i) {
            String stringValue;
            PropertyAccessor property = keyProperties[i];
            Object value = property.get(object);
            array[i] = stringValue = (String)OgnlUtils.convertValue((Object)value, String.class);
        }
        return array;
    }

    public TextFormat createPkGenerator() {
        String formatString = this.getFormatString();
        return OgnlTextFormat.create((String)formatString);
    }

    @NotNull
    public String getFormatString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (PropertyAccessor property : this.classAccessor.getKeyProperties()) {
            if (first) {
                first = false;
            } else {
                sb.append("/");
            }
            sb.append("%{");
            sb.append(property.getName());
            sb.append("}");
        }
        return sb.toString();
    }

    public String getPkStringForUrl(Object o, String encoding) throws UnsupportedEncodingException {
        return this.getPkStringForUrl(this.generatePkStringArray(o), encoding);
    }

    public String getPkStringForUrl(String[] pk, String encoding) throws UnsupportedEncodingException {
        String[] escapedPk = new String[pk.length];
        for (int i = 0; i < pk.length; ++i) {
            escapedPk[i] = URLEncoder.encode(pk[i], encoding);
        }
        return this.getPkString(escapedPk);
    }

    @Nullable
    public String getPkString(String[] pkStringArray) {
        return StringUtils.join((Object[])pkStringArray, (String)"/");
    }

    public String getPkString(Object object) {
        return this.getPkString(this.generatePkStringArray(object));
    }
}

