/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.modules;

import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.modules.Module;
import com.manydesigns.portofino.modules.ModuleStatus;
import com.manydesigns.portofino.persistence.Persistence;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.ContextRefreshedEvent;

public class DatabaseModule
implements Module,
ApplicationContextAware,
ApplicationListener {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    @Autowired
    public ServletContext servletContext;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.portofinoConfiguration")
    public Configuration configuration;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.portofinoConfigurationFile")
    public FileBasedConfigurationBuilder<PropertiesConfiguration> configurationFile;
    @Autowired
    @Qualifier(value="com.manydesigns.portofino.application.directory")
    public FileObject applicationDirectory;
    protected ApplicationContext applicationContext;
    protected ModuleStatus status = ModuleStatus.CREATED;
    public static final String LIQUIBASE_ENABLED = "liquibase.enabled";
    public static final Logger logger = LoggerFactory.getLogger(DatabaseModule.class);

    public String getModuleVersion() {
        return Module.getPortofinoVersion();
    }

    public String getName() {
        return "Database";
    }

    @PostConstruct
    public void init() {
        this.status = ModuleStatus.ACTIVE;
    }

    @Bean
    public DatabasePlatformsRegistry getDatabasePlatformsRegistry() {
        return new DatabasePlatformsRegistry(this.configuration);
    }

    @Bean
    public Persistence getPersistence(@Autowired DatabasePlatformsRegistry databasePlatformsRegistry, @Autowired CacheResetListenerRegistry cacheResetListenerRegistry) throws FileSystemException {
        Persistence persistence = new Persistence(this.applicationDirectory, this.configuration, this.configurationFile, databasePlatformsRegistry);
        persistence.cacheResetListenerRegistry = cacheResetListenerRegistry;
        return persistence;
    }

    @PreDestroy
    public void destroy() {
        logger.info("ManyDesigns Portofino database module stopping...");
        ((Persistence)this.applicationContext.getBean(Persistence.class)).stop();
        logger.info("ManyDesigns Portofino database module stopped.");
        this.status = ModuleStatus.DESTROYED;
    }

    public ModuleStatus getStatus() {
        return this.status;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(@NotNull ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            Persistence persistence = (Persistence)this.applicationContext.getBean(Persistence.class);
            Persistence.Status status = (Persistence.Status)((Object)persistence.status.getValue());
            if (status == null || status == Persistence.Status.STOPPED) {
                logger.info("Starting persistence...");
                persistence.start();
                this.status = ModuleStatus.STARTED;
                logger.info("Persistence started.");
            }
        }
    }
}

