/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;

public class StringBooleanType
implements EnhancedUserType,
ParameterizedType {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    private int sqlType = 1;
    public static final String NULL = "null";
    private String trueString = "T";
    private String falseString = "F";

    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    public Class returnedClass() {
        return Boolean.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return ObjectUtils.equals((Object)x, (Object)y);
    }

    public int hashCode(Object x) throws HibernateException {
        return ObjectUtils.hashCode((Object)x);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, SessionImplementor sessionImplementor, Object owner) throws HibernateException, SQLException {
        String value = resultSet.getString(names[0]);
        return this.parseBoolean(value);
    }

    protected Object parseBoolean(String value) {
        if (value != null) {
            if (value.trim().equalsIgnoreCase(this.trueString)) {
                return Boolean.TRUE;
            }
            if (value.trim().equalsIgnoreCase(this.falseString)) {
                return Boolean.FALSE;
            }
            throw new HibernateException("Invalid boolean value: " + value + "; possible values are " + this.trueString + ", " + this.falseString + ", null");
        }
        if (this.trueString == null) {
            return true;
        }
        if (this.falseString == null) {
            return false;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void nullSafeSet(PreparedStatement statement, Object value, int index, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (value == null) {
            if (this.trueString == null || this.falseString == null) throw new HibernateException("Null is not supported as a boolean value for this type");
            statement.setString(index, null);
            return;
        } else {
            statement.setString(index, (Boolean)value != false ? this.trueString : this.falseString);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public String getTrueString() {
        return this.trueString;
    }

    public String getFalseString() {
        return this.falseString;
    }

    public void setParameterValues(Properties parameters) {
        String nullValue = new String();
        String newString = parameters.getProperty("true", nullValue);
        if (newString != nullValue) {
            String string = this.trueString = newString != NULL ? newString : null;
        }
        if ((newString = parameters.getProperty("false", nullValue)) != nullValue) {
            String string = this.falseString = newString != NULL ? newString : null;
        }
        if (this.trueString == this.falseString || this.trueString != null && this.trueString.equals(this.falseString)) {
            throw new IllegalArgumentException("trueString and falseString must be distinct");
        }
        String sqlTypeCode = parameters.getProperty("sqlType");
        if (sqlTypeCode != null) {
            this.sqlType = Integer.parseInt(sqlTypeCode);
        }
    }

    public String objectToSQLString(Object value) {
        if (((Boolean)value).booleanValue()) {
            return '\'' + this.trueString + '\'';
        }
        return '\'' + this.falseString + '\'';
    }

    public String toXMLString(Object value) {
        if (((Boolean)value).booleanValue()) {
            return this.trueString;
        }
        return this.falseString;
    }

    public Object fromXMLString(String xmlValue) {
        return this.parseBoolean(xmlValue);
    }
}

