/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import com.manydesigns.portofino.model.database.ModelSelectionProvider;
import com.manydesigns.portofino.model.database.Reference;
import com.manydesigns.portofino.model.database.Table;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"name", "toDatabase", "references", "hql", "sql"})
public class DatabaseSelectionProvider
implements ModelSelectionProvider {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    protected final List<Reference> references = new ArrayList<Reference>();
    protected String name;
    protected String toDatabase;
    protected String sql;
    protected String hql;
    protected Table fromTable;
    public static final Logger logger = LoggerFactory.getLogger(DatabaseSelectionProvider.class);

    public DatabaseSelectionProvider() {
    }

    public DatabaseSelectionProvider(Table fromTable) {
        this();
        this.fromTable = fromTable;
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.fromTable = (Table)parent;
    }

    @Override
    public void reset() {
    }

    @Override
    public void init(Model model) {
        if (this.name == null) {
            throw new RuntimeException("name is required. Parent: " + this.fromTable.getQualifiedName());
        }
        if (this.toDatabase == null) {
            if (this.fromTable != null && this.fromTable.getSchema() != null) {
                this.toDatabase = this.fromTable.getSchema().getDatabaseName();
            }
            if (this.toDatabase == null) {
                throw new RuntimeException("toDatabase is required. Parent: " + this.fromTable.getQualifiedName());
            }
        }
    }

    @Override
    public void link(Model model) {
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
        for (Reference reference : this.references) {
            visitor.visit(reference);
        }
    }

    public String getQualifiedName() {
        return this.name;
    }

    @Override
    @XmlElementWrapper(name="references")
    @XmlElement(name="reference", type=Reference.class)
    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    @XmlAttribute(required=true)
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlAttribute(required=true)
    public String getToDatabase() {
        return this.toDatabase;
    }

    @Override
    public void setToDatabase(String toDatabase) {
        this.toDatabase = toDatabase;
    }

    @XmlAttribute(required=false)
    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @XmlAttribute(required=false)
    public String getHql() {
        return this.hql;
    }

    public void setHql(String hql) {
        this.hql = hql;
    }

    @Override
    public Table getFromTable() {
        return this.fromTable;
    }

    @Override
    public void setFromTable(Table fromTable) {
        this.fromTable = fromTable;
    }

    @Override
    public Table getToTable() {
        return null;
    }
}

