/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.elements.annotations.DateFormat;
import com.manydesigns.elements.annotations.Label;
import com.manydesigns.elements.annotations.Updatable;
import com.manydesigns.portofino.database.DbUtil;
import com.manydesigns.portofino.database.Type;
import com.manydesigns.portofino.database.platforms.DatabasePlatform;
import com.manydesigns.portofino.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.model.database.JdbcConnectionProvider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class ConnectionProvider {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    public static final String STATUS_DISCONNECTED = "disconnected";
    public static final String STATUS_CONNECTED = "connected";
    public static final String STATUS_ERROR = "error";
    protected final List<Type> types = new ArrayList<Type>();
    protected String databaseProductName;
    protected String databaseProductVersion;
    protected Integer databaseMajorVersion;
    protected Integer databaseMinorVersion;
    protected String databaseMajorMinorVersion;
    protected String driverName;
    protected String driverVersion;
    protected Integer driverMajorVersion;
    protected Integer driverMinorVersion;
    protected String driverMajorMinorVersion;
    protected Integer JDBCMajorVersion;
    protected Integer JDBCMinorVersion;
    protected String JDBCMajorMinorVersion;
    protected DatabasePlatform databasePlatform;
    protected String status;
    protected String errorMessage;
    protected Date lastTested;
    protected Database database;
    protected String hibernateDialect;
    public static final Logger logger = LoggerFactory.getLogger(JdbcConnectionProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DatabasePlatformsRegistry databasePlatformsRegistry) {
        ResultSet typeRs;
        Connection conn;
        block11: {
            conn = null;
            typeRs = null;
            String databaseName = this.getDatabase().getDatabaseName();
            try {
                conn = this.acquireConnection();
                DatabaseMetaData metadata = conn.getMetaData();
                this.databaseProductName = metadata.getDatabaseProductName();
                this.databaseProductVersion = metadata.getDatabaseProductVersion();
                try {
                    this.databaseMajorVersion = metadata.getDatabaseMajorVersion();
                    this.databaseMinorVersion = metadata.getDatabaseMinorVersion();
                    this.databaseMajorMinorVersion = MessageFormat.format("{0}.{1}", this.databaseMajorVersion, this.databaseMinorVersion);
                }
                catch (SQLException e) {
                    this.databaseMajorMinorVersion = e.getMessage();
                }
                this.driverName = metadata.getDriverName();
                this.driverVersion = metadata.getDriverVersion();
                this.driverMajorVersion = metadata.getDriverMajorVersion();
                this.driverMinorVersion = metadata.getDriverMinorVersion();
                this.driverMajorMinorVersion = MessageFormat.format("{0}.{1}", this.driverMajorVersion, this.driverMinorVersion);
                try {
                    this.JDBCMajorVersion = metadata.getJDBCMajorVersion();
                    this.JDBCMinorVersion = metadata.getJDBCMinorVersion();
                    this.JDBCMajorMinorVersion = MessageFormat.format("{0}.{1}", this.JDBCMajorVersion, this.JDBCMinorVersion);
                }
                catch (Throwable e) {
                    this.JDBCMajorMinorVersion = e.getMessage();
                }
                this.types.clear();
                typeRs = metadata.getTypeInfo();
                while (typeRs.next()) {
                    this.readType(typeRs);
                }
                this.fixMissingTypeAliases(this.types);
                Collections.sort(this.types, new TypeComparator());
                this.databasePlatform = databasePlatformsRegistry.findApplicableAbstraction(this);
                if (this.databasePlatform == null) {
                    this.status = STATUS_ERROR;
                    this.errorMessage = MessageFormat.format("Database platform not found for {0}", this.databaseProductName);
                    logger.warn(this.errorMessage);
                    break block11;
                }
                this.status = STATUS_CONNECTED;
                this.errorMessage = null;
            }
            catch (Throwable e) {
                try {
                    this.status = STATUS_ERROR;
                    this.errorMessage = e.getMessage();
                    logger.warn("Could not create database platform for " + databaseName, e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DbUtil.closeResultSetAndStatement(typeRs);
                    this.releaseConnection(conn);
                    this.lastTested = new Date();
                }
            }
        }
        DbUtil.closeResultSetAndStatement(typeRs);
        this.releaseConnection(conn);
        this.lastTested = new Date();
    }

    protected void fixMissingTypeAliases(List<Type> types) {
        Type numericType = null;
        Type decimalType = null;
        for (Type type : types) {
            if (type.getJdbcType() == 2) {
                numericType = type;
                continue;
            }
            if (type.getJdbcType() != 3) continue;
            decimalType = type;
        }
        if (numericType == null && decimalType != null) {
            numericType = new Type("NUMERIC", 2, decimalType.getMaximumPrecision(), decimalType.getLiteralPrefix(), decimalType.getLiteralSuffix(), decimalType.isNullable(), decimalType.isCaseSensitive(), decimalType.isSearchable(), decimalType.isAutoincrement(), decimalType.getMinimumScale(), decimalType.getMaximumScale(), decimalType.isPrecisionRequired(), decimalType.isScaleRequired());
            types.add(numericType);
            logger.info("Added NUMERIC type as an alias of DECIMAL");
        } else if (decimalType == null && numericType != null) {
            decimalType = new Type("DECIMAL", 3, numericType.getMaximumPrecision(), numericType.getLiteralPrefix(), numericType.getLiteralSuffix(), numericType.isNullable(), numericType.isCaseSensitive(), numericType.isSearchable(), numericType.isAutoincrement(), numericType.getMinimumScale(), numericType.getMaximumScale(), numericType.isPrecisionRequired(), numericType.isScaleRequired());
            types.add(decimalType);
            logger.info("Added DECIMAL type as an alias of NUMERIC");
        }
    }

    public void shutdown() {
        if (this.databasePlatform != null) {
            this.databasePlatform.shutdown(this);
        }
    }

    protected void readType(ResultSet typeRs) throws SQLException {
        Integer maximumPrecision;
        String typeName = typeRs.getString("TYPE_NAME");
        int dataType = typeRs.getInt("DATA_TYPE");
        Object maximumPrecisionObj = typeRs.getObject("PRECISION");
        if (maximumPrecisionObj instanceof Number) {
            maximumPrecision = ((Number)maximumPrecisionObj).intValue();
        } else {
            maximumPrecision = null;
            logger.warn("Cannot get maximum precision for type: {} value: {}", (Object)typeName, maximumPrecisionObj);
        }
        String literalPrefix = typeRs.getString("LITERAL_PREFIX");
        String literalSuffix = typeRs.getString("LITERAL_SUFFIX");
        boolean nullable = typeRs.getShort("NULLABLE") == 1;
        boolean caseSensitive = typeRs.getBoolean("CASE_SENSITIVE");
        boolean searchable = typeRs.getShort("SEARCHABLE") == 3;
        boolean autoincrement = typeRs.getBoolean("AUTO_INCREMENT");
        short minimumScale = typeRs.getShort("MINIMUM_SCALE");
        short maximumScale = typeRs.getShort("MAXIMUM_SCALE");
        Type type = new Type(typeName, dataType, maximumPrecision, literalPrefix, literalSuffix, nullable, caseSensitive, searchable, autoincrement, minimumScale, maximumScale);
        this.types.add(type);
    }

    public abstract String getDescription();

    public abstract Connection acquireConnection() throws Exception;

    public abstract void releaseConnection(Connection var1);

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.database = (Database)parent;
    }

    @Updatable(value=false)
    public String getStatus() {
        return this.status;
    }

    @Updatable(value=false)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @DateFormat(value="yyyy-MM-dd HH:mm:ss")
    @Updatable(value=false)
    public Date getLastTested() {
        return this.lastTested;
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public Integer getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public Integer getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    @Label(value="database major/minor version")
    public String getDatabaseMajorMinorVersion() {
        return this.databaseMajorMinorVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public Integer getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public Integer getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Label(value="driver major/minor version")
    public String getDriverMajorMinorVersion() {
        return this.driverMajorMinorVersion;
    }

    public Integer getJDBCMajorVersion() {
        return this.JDBCMajorVersion;
    }

    public Integer getJDBCMinorVersion() {
        return this.JDBCMinorVersion;
    }

    @Label(value="JDBC major/minor version")
    public String getJDBCMajorMinorVersion() {
        return this.JDBCMajorMinorVersion;
    }

    @XmlAttribute(required=false)
    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    public void setHibernateDialect(String hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Type[] getTypes() {
        Type[] result = new Type[this.types.size()];
        return this.types.toArray(result);
    }

    public boolean isHibernateDialectAutodetected() {
        return StringUtils.isBlank((String)this.hibernateDialect) && (this.getDatabasePlatform() == null || this.getDatabasePlatform().isDialectAutodetected());
    }

    public String getActualHibernateDialectName() {
        if (StringUtils.isBlank((String)this.hibernateDialect)) {
            return this.getDatabasePlatform().getHibernateDialect().getClass().getName();
        }
        return this.hibernateDialect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionProvider that = (ConnectionProvider)o;
        return !(this.database != null ? !this.database.equals(that.database) : that.database != null);
    }

    public int hashCode() {
        return this.database != null ? this.database.hashCode() : 0;
    }

    private static class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            return o1.getTypeName().compareToIgnoreCase(o2.getTypeName());
        }
    }
}

