/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.type.Type;

public class PortofinoIdentityGenerator
extends IdentityGenerator {
    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(PostInsertIdentityPersister persister, Dialect dialect, boolean isGetGeneratedKeysEnabled) throws HibernateException {
        if (isGetGeneratedKeysEnabled) {
            return new PortofinoGetGeneratedKeysDelegate(persister, dialect);
        }
        if (dialect.supportsInsertSelectIdentity()) {
            return new IdentityGenerator.InsertSelectDelegate(persister, dialect);
        }
        return new IdentityGenerator.BasicDelegate(persister, dialect);
    }

    public static class PortofinoGetGeneratedKeysDelegate
    extends IdentityGenerator.GetGeneratedKeysDelegate
    implements InsertGeneratedIdentifierDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;

        public PortofinoGetGeneratedKeysDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
            super(persister, dialect);
            this.persister = persister;
            this.dialect = dialect;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Serializable executeAndExtract(PreparedStatement insert, SessionImplementor session) throws SQLException {
            session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(insert);
            ResultSet rs = null;
            try {
                rs = insert.getGeneratedKeys();
                Serializable serializable = IdentifierGeneratorHelper.getGeneratedIdentity((ResultSet)rs, (String)this.unquotedIdentifier(this.persister.getRootTableKeyColumnNames()[0]), (Type)this.persister.getIdentifierType());
                return serializable;
            }
            finally {
                if (rs != null) {
                    session.getTransactionCoordinator().getJdbcCoordinator().release(rs, (Statement)insert);
                }
            }
        }

        protected String unquotedIdentifier(String identifier) {
            if (identifier.startsWith("" + this.dialect.openQuote())) {
                return identifier.substring(1, identifier.length() - 1);
            }
            return identifier;
        }
    }
}

