/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.reflection;

import com.manydesigns.elements.annotations.ShortName;
import com.manydesigns.elements.annotations.impl.ShortNameImpl;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.PrimaryKey;
import com.manydesigns.portofino.model.database.PrimaryKeyColumn;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.reflection.AbstractAnnotatedAccessor;
import com.manydesigns.portofino.reflection.ColumnAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableAccessor
extends AbstractAnnotatedAccessor
implements ClassAccessor {
    public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
    protected final Table table;
    protected final ColumnAccessor[] columnAccessors;
    protected final ColumnAccessor[] keyColumnAccessors;
    protected ClassAccessor javaClassAccessor = null;
    public static final Logger logger = LoggerFactory.getLogger(TableAccessor.class);

    public TableAccessor(@NotNull Table table) {
        super(table.getAnnotations());
        Class clazz;
        if (!StringUtils.isEmpty((String)table.getShortName())) {
            ShortNameImpl shortName = new ShortNameImpl(table.getShortName());
            this.annotations.put(ShortName.class, shortName);
        }
        if ((clazz = table.getActualJavaClass()) != null) {
            this.javaClassAccessor = JavaClassAccessor.getClassAccessor((Class)clazz);
        }
        this.table = table;
        List columns = table.getColumns();
        List pkColumns = table.getPrimaryKey().getColumns();
        PrimaryKey pk = table.getPrimaryKey();
        this.columnAccessors = new ColumnAccessor[columns.size()];
        this.keyColumnAccessors = new ColumnAccessor[pkColumns.size()];
        this.setupColumns(columns, pkColumns, pk);
        this.setupKeyColumns(columns, pkColumns);
    }

    private void setupColumns(List<Column> columns, List<Column> pkColumns, PrimaryKey pk) {
        int i = 0;
        for (Column current : columns) {
            ColumnAccessor columnAccessor;
            PropertyAccessor nestedPropertyAccessor;
            boolean inPk = pkColumns.contains(current);
            if (this.javaClassAccessor == null) {
                nestedPropertyAccessor = null;
            } else {
                String propertyName = current.getActualPropertyName();
                try {
                    nestedPropertyAccessor = this.javaClassAccessor.getProperty(propertyName);
                }
                catch (NoSuchFieldException e) {
                    nestedPropertyAccessor = null;
                    logger.error("Could not access nested property: " + propertyName, (Throwable)e);
                }
            }
            boolean autoGenerated = inPk && ((PrimaryKeyColumn)pk.getPrimaryKeyColumns().get(0)).getGenerator() != null;
            this.columnAccessors[i] = columnAccessor = new ColumnAccessor(current, inPk, autoGenerated, nestedPropertyAccessor);
            ++i;
        }
    }

    private void setupKeyColumns(List<Column> columns, List<Column> pkColumns) {
        int i = 0;
        for (Column current : pkColumns) {
            ColumnAccessor columnAccessor;
            int index = columns.indexOf(current);
            this.keyColumnAccessors[i] = columnAccessor = this.columnAccessors[index];
            ++i;
        }
    }

    public String getName() {
        return this.table.getQualifiedName();
    }

    public Class<?> getType() {
        if (this.javaClassAccessor == null) {
            return Map.class;
        }
        return this.javaClassAccessor.getType();
    }

    public PropertyAccessor getProperty(String propertyName) throws NoSuchFieldException {
        for (ColumnAccessor current : this.columnAccessors) {
            if (!current.getName().equals(propertyName)) continue;
            return current;
        }
        throw new NoSuchFieldException(propertyName);
    }

    public PropertyAccessor[] getProperties() {
        return (PropertyAccessor[])this.columnAccessors.clone();
    }

    public PropertyAccessor[] getKeyProperties() {
        return (PropertyAccessor[])this.keyColumnAccessors.clone();
    }

    public Object newInstance() {
        if (this.javaClassAccessor == null) {
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("$type$", this.table.getEntityName());
            return obj;
        }
        return this.javaClassAccessor.newInstance();
    }

    public Table getTable() {
        return this.table;
    }
}

