/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence;

import com.manydesigns.elements.configuration.CommonsConfigurationUtils;
import com.manydesigns.elements.util.ElementsFileUtils;
import com.manydesigns.portofino.cache.CacheResetEvent;
import com.manydesigns.portofino.cache.CacheResetListenerRegistry;
import com.manydesigns.portofino.di.Inject;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.Schema;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatformsRegistry;
import com.manydesigns.portofino.persistence.hibernate.HibernateConfig;
import com.manydesigns.portofino.persistence.hibernate.HibernateDatabaseSetup;
import com.manydesigns.portofino.reflection.TableAccessor;
import com.manydesigns.portofino.sync.DatabaseSyncer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persistence {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final String APP_DBS_DIR = "dbs";
    public static final String APP_MODEL_FILE = "portofino-model.xml";
    public static final String APP_CONTEXT = "liquibase.context";
    public static final String changelogFileNameTemplate = "{0}-changelog.xml";
    protected final DatabasePlatformsRegistry databasePlatformsRegistry;
    protected Model model;
    protected final Map<String, HibernateDatabaseSetup> setups;
    protected final File appDir;
    protected final File appDbsDir;
    protected final File appModelFile;
    protected final Configuration configuration;
    @Inject(value="com.manydesigns.portofino.cache.CacheResetListenerRegistry")
    public CacheResetListenerRegistry cacheResetListenerRegistry;
    public static final Logger logger = LoggerFactory.getLogger(Persistence.class);

    public Persistence(File appDir, Configuration configuration, DatabasePlatformsRegistry databasePlatformsRegistry) {
        this.appDir = appDir;
        this.configuration = configuration;
        this.databasePlatformsRegistry = databasePlatformsRegistry;
        this.appDbsDir = new File(appDir, APP_DBS_DIR);
        logger.info("Application dbs dir: {}", (Object)this.appDbsDir.getAbsolutePath());
        boolean result = ElementsFileUtils.ensureDirectoryExistsAndWarnIfNotWritable((File)this.appDbsDir);
        this.appModelFile = new File(appDir, APP_MODEL_FILE);
        logger.info("Application model file: {}", (Object)this.appModelFile.getAbsolutePath());
        if (!result) {
            throw new Error("Could not initialize application");
        }
        this.setups = new HashMap<String, HibernateDatabaseSetup>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadXmlModel() {
        logger.info("Loading xml model from file: {}", (Object)this.appModelFile.getAbsolutePath());
        try {
            JAXBContext jc = JAXBContext.newInstance((String)Model.class.getPackage().getName());
            Unmarshaller um = jc.createUnmarshaller();
            Model model = (Model)um.unmarshal(this.appModelFile);
            File modelDir = this.getModelDirectory();
            for (com.manydesigns.portofino.model.database.Database database : model.getDatabases()) {
                File databaseDir = new File(modelDir, database.getDatabaseName());
                for (Schema schema : database.getSchemas()) {
                    File schemaDir = new File(databaseDir, schema.getSchemaName());
                    if (schemaDir.isDirectory()) {
                        File[] tableFiles;
                        logger.debug("Schema directory {} exists", (Object)schemaDir);
                        for (File tableFile : tableFiles = schemaDir.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith(".table.xml");
                            }
                        })) {
                            Table table = (Table)um.unmarshal(tableFile);
                            if (!tableFile.getName().equalsIgnoreCase(table.getTableName() + ".table.xml")) {
                                throw new Exception("Found table " + table.getTableName() + " defined in file " + tableFile);
                            }
                            table.afterUnmarshal(um, (Object)schema);
                            schema.getTables().add(table);
                        }
                        continue;
                    }
                    logger.debug("Schema directory {} does not exist", (Object)schemaDir);
                }
                File settingsFile = new File(databaseDir, "hibernate.properties");
                if (!settingsFile.exists()) continue;
                Properties settings = new Properties();
                FileInputStream propertiesStream = null;
                try {
                    propertiesStream = new FileInputStream(settingsFile);
                    settings.load(propertiesStream);
                    database.setSettings(settings);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(propertiesStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)propertiesStream);
            }
            this.model = model;
            this.initModel();
        }
        catch (Exception e) {
            String msg = "Cannot load/parse model: " + this.appModelFile;
            logger.error(msg, (Throwable)e);
        }
    }

    public File getModelDirectory() {
        return new File(this.appModelFile.getParentFile(), FilenameUtils.getBaseName((String)this.appModelFile.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runLiquibase(com.manydesigns.portofino.model.database.Database database) {
        logger.info("Updating database definitions");
        FileSystemResourceAccessor resourceAccessor = new FileSystemResourceAccessor(this.appDir.getAbsolutePath());
        ConnectionProvider connectionProvider = database.getConnectionProvider();
        String databaseName = database.getDatabaseName();
        for (Schema schema : database.getSchemas()) {
            String schemaName = schema.getSchemaName();
            String changelogFileName = MessageFormat.format(changelogFileNameTemplate, databaseName + "-" + schemaName);
            File changelogFile = new File(this.appDbsDir, changelogFileName);
            if (!changelogFile.isFile()) {
                logger.info("Changelog file does not exist or is not a normal file, skipping: {}", (Object)changelogFile);
                continue;
            }
            logger.info("Running changelog file: {}", (Object)changelogFile);
            Connection connection = null;
            try {
                connection = connectionProvider.acquireConnection();
                JdbcConnection jdbcConnection = new JdbcConnection(connection);
                Database lqDatabase = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConnection);
                lqDatabase.setDefaultSchemaName(schema.getSchema());
                String relativeChangelogPath = ElementsFileUtils.getRelativePath((File)this.appDir, (File)changelogFile, (String)System.getProperty("file.separator"));
                if (new File(relativeChangelogPath).isAbsolute()) {
                    logger.warn("The application dbs dir {} is not inside the apps dir {}; using an absolute path for Liquibase update", (Object)this.appDbsDir, (Object)this.appDir);
                }
                Liquibase lq = new Liquibase(relativeChangelogPath, (ResourceAccessor)resourceAccessor, lqDatabase);
                Object[] contexts = this.configuration.getStringArray(APP_CONTEXT);
                logger.info("Using context {}", (Object)Arrays.toString(contexts));
                lq.update(new Contexts((String[])contexts));
            }
            catch (Exception e) {
                String msg = "Couldn't update database: " + schemaName;
                logger.error(msg, (Throwable)e);
            }
            finally {
                connectionProvider.releaseConnection(connection);
            }
        }
    }

    public synchronized void saveXmlModel() throws IOException, JAXBException {
        File tempFile = File.createTempFile(this.appModelFile.getName(), "");
        JAXBContext jc = JAXBContext.newInstance((String)Model.class.getPackage().getName());
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)this.model, tempFile);
        ElementsFileUtils.moveFileSafely((File)tempFile, (String)this.appModelFile.getAbsolutePath());
        File modelDir = this.getModelDirectory();
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            File databaseDir = new File(modelDir, database.getDatabaseName());
            for (Schema schema : database.getSchemas()) {
                File schemaDir = new File(databaseDir, schema.getSchemaName());
                if (schemaDir.isDirectory() || schemaDir.mkdirs()) {
                    logger.debug("Schema directory {} exists", (Object)schemaDir);
                    File[] tableFiles = schemaDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".table.xml");
                        }
                    });
                    for (File tableFile : tableFiles) {
                        if (tableFile.delete()) continue;
                        logger.warn("Could not delete table file {}", (Object)tableFile.getAbsolutePath());
                    }
                    for (Table table : schema.getTables()) {
                        File tableFile = new File(schemaDir, table.getTableName() + ".table.xml");
                        m.marshal((Object)table, tableFile);
                    }
                    continue;
                }
                logger.debug("Schema directory {} does not exist", (Object)schemaDir);
            }
        }
        try {
            CommonsConfigurationUtils.save((Configuration)this.configuration);
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        logger.info("Saved xml model to file: {}", (Object)this.appModelFile);
    }

    public synchronized void initModel() {
        logger.info("Cleaning up old setups");
        for (Map.Entry<String, HibernateDatabaseSetup> current : this.setups.entrySet()) {
            String databaseName = current.getKey();
            logger.info("Cleaning up old setup for: {}", (Object)databaseName);
            HibernateDatabaseSetup hibernateDatabaseSetup = current.getValue();
            try {
                SessionFactory sessionFactory = hibernateDatabaseSetup.getSessionFactory();
                sessionFactory.close();
            }
            catch (Throwable t) {
                logger.warn("Cannot close session factory for: " + databaseName, t);
            }
        }
        this.setups.clear();
        this.model.init(this.configuration);
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            if (database.getEnabled().booleanValue()) {
                logger.info("Database " + database.getDatabaseName() + " enabled");
                try {
                    String falseString;
                    ConnectionProvider connectionProvider = database.getConnectionProvider();
                    connectionProvider.init(this.databasePlatformsRegistry);
                    if (!connectionProvider.getStatus().equals("connected")) continue;
                    HibernateConfig builder = new HibernateConfig(connectionProvider, this.configuration);
                    String trueString = database.getTrueString();
                    if (trueString != null) {
                        builder.setTrueString("null".equalsIgnoreCase(trueString) ? null : trueString);
                    }
                    if ((falseString = database.getFalseString()) != null) {
                        builder.setFalseString("null".equalsIgnoreCase(falseString) ? null : falseString);
                    }
                    org.hibernate.cfg.Configuration configuration = builder.buildSessionFactory(database);
                    StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties());
                    SessionFactory sessionFactory = configuration.buildSessionFactory((ServiceRegistry)registryBuilder.build());
                    HibernateDatabaseSetup setup = new HibernateDatabaseSetup(configuration, sessionFactory);
                    String databaseName = database.getDatabaseName();
                    this.setups.put(databaseName, setup);
                }
                catch (Exception e) {
                    logger.error("Could not create connection provider for " + database, (Throwable)e);
                }
                continue;
            }
            logger.info("Database " + database.getDatabaseName() + " disabled");
        }
        this.cacheResetListenerRegistry.fireReset(new CacheResetEvent((Object)this));
    }

    public ConnectionProvider getConnectionProvider(String databaseName) {
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            if (!database.getDatabaseName().equals(databaseName)) continue;
            return database.getConnectionProvider();
        }
        return null;
    }

    public Configuration getPortofinoProperties() {
        return this.configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public DatabasePlatformsRegistry getDatabasePlatformsRegistry() {
        return this.databasePlatformsRegistry;
    }

    public Model getModel() {
        return this.model;
    }

    public synchronized void syncDataModel(String databaseName) throws Exception {
        com.manydesigns.portofino.model.database.Database sourceDatabase = DatabaseLogic.findDatabaseByName((Model)this.model, (String)databaseName);
        if (this.configuration.getBoolean("liquibase.enabled", true)) {
            this.runLiquibase(sourceDatabase);
        } else {
            logger.debug("syncDataModel called, but Liquibase is not enabled");
        }
        ConnectionProvider connectionProvider = sourceDatabase.getConnectionProvider();
        DatabaseSyncer dbSyncer = new DatabaseSyncer(connectionProvider);
        com.manydesigns.portofino.model.database.Database targetDatabase = dbSyncer.syncDatabase(this.model);
        this.model.getDatabases().remove(sourceDatabase);
        this.model.getDatabases().add(targetDatabase);
    }

    public Session getSession(String databaseName) {
        return this.ensureDatabaseSetup(databaseName).getThreadSession();
    }

    protected HibernateDatabaseSetup ensureDatabaseSetup(String databaseName) {
        HibernateDatabaseSetup setup = this.setups.get(databaseName);
        if (setup == null) {
            throw new Error("No setup exists for database: " + databaseName);
        }
        return setup;
    }

    public void closeSessions() {
        for (HibernateDatabaseSetup current : this.setups.values()) {
            this.closeSession(current);
        }
    }

    public void closeSession(String databaseName) {
        this.closeSession(this.ensureDatabaseSetup(databaseName));
    }

    protected void closeSession(HibernateDatabaseSetup current) {
        Session session = current.getThreadSession(false);
        if (session != null) {
            try {
                Transaction transaction = session.getTransaction();
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
                session.close();
            }
            catch (Throwable e) {
                logger.warn("Couldn't close session: " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
            }
            current.removeThreadSession();
        }
    }

    @NotNull
    public TableAccessor getTableAccessor(String databaseName, String entityName) {
        com.manydesigns.portofino.model.database.Database database = DatabaseLogic.findDatabaseByName((Model)this.model, (String)databaseName);
        assert (database != null);
        Table table = DatabaseLogic.findTableByEntityName((com.manydesigns.portofino.model.database.Database)database, (String)entityName);
        assert (table != null);
        return new TableAccessor(table);
    }

    public void start() {
        this.loadXmlModel();
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            if (database.getEnabled().booleanValue()) {
                logger.info("Database " + database.getDatabaseName() + " enabled");
                this.runLiquibase(database);
                continue;
            }
            logger.info("Database " + database.getDatabaseName() + " disabled");
        }
    }

    public void stop() {
        for (HibernateDatabaseSetup setup : this.setups.values()) {
            setup.getSessionFactory().close();
        }
        for (com.manydesigns.portofino.model.database.Database database : this.model.getDatabases()) {
            ConnectionProvider connectionProvider = database.getConnectionProvider();
            connectionProvider.shutdown();
        }
    }

    public String getName() {
        return this.getPortofinoProperties().getString("app.name");
    }

    public File getAppDbsDir() {
        return this.appDbsDir;
    }

    public File getAppModelFile() {
        return this.appModelFile;
    }
}

