/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.util;

import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.text.OgnlTextFormat;
import com.manydesigns.elements.text.TextFormat;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkHelper {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(PkHelper.class);
    protected final ClassAccessor classAccessor;

    public PkHelper(ClassAccessor classAccessor) {
        this.classAccessor = classAccessor;
    }

    public TextFormat createPkGenerator() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (PropertyAccessor property : this.classAccessor.getKeyProperties()) {
            if (first) {
                first = false;
            } else {
                sb.append("/");
            }
            sb.append("%{");
            sb.append(property.getName());
            sb.append("}");
        }
        return OgnlTextFormat.create((String)sb.toString());
    }

    public Serializable getPrimaryKey(String ... params) {
        int i = 0;
        Serializable result = (Serializable)this.classAccessor.newInstance();
        if (params.length != this.classAccessor.getKeyProperties().length) {
            throw new RuntimeException("Wrong number of parameters for primary key: expected " + this.classAccessor.getKeyProperties().length + ", got " + params.length);
        }
        for (PropertyAccessor property : this.classAccessor.getKeyProperties()) {
            String stringValue = params[i];
            Object value = OgnlUtils.convertValue((Object)stringValue, (Class)property.getType());
            property.set((Object)result, value);
            ++i;
        }
        return result;
    }

    public String[] generatePkStringArray(Object object) {
        PropertyAccessor[] keyProperties = this.classAccessor.getKeyProperties();
        String[] array = new String[keyProperties.length];
        for (int i = 0; i < keyProperties.length; ++i) {
            String stringValue;
            PropertyAccessor property = keyProperties[i];
            Object value = property.get(object);
            array[i] = stringValue = (String)OgnlUtils.convertValue((Object)value, String.class);
        }
        return array;
    }

    public String getPkStringForUrl(Object o, String encoding) throws UnsupportedEncodingException {
        return this.getPkStringForUrl(this.generatePkStringArray(o), encoding);
    }

    public String getPkStringForUrl(String[] pk, String encoding) throws UnsupportedEncodingException {
        Object[] escapedPk = new String[pk.length];
        for (int i = 0; i < pk.length; ++i) {
            escapedPk[i] = URLEncoder.encode(pk[i], encoding);
        }
        return StringUtils.join((Object[])escapedPk, (String)"/");
    }
}

