/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.servlets;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.BlobManager;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobCleanupListener
implements HttpSessionListener {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final String SESSION_ATTRIBUTE = BlobCleanupListener.class.getName();
    public static final Logger logger = LoggerFactory.getLogger(BlobCleanupListener.class);

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        httpSessionEvent.getSession().setAttribute(SESSION_ATTRIBUTE, new ConcurrentSkipListSet());
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        Set blobs = (Set)session.getAttribute(SESSION_ATTRIBUTE);
        BlobManager blobManager = ElementsThreadLocals.getBlobManager();
        if (blobManager == null) {
            blobManager = BlobManager.createDefaultBlobManager();
        }
        for (String blobCode : blobs) {
            logger.info("Deleting unused blob: " + blobCode);
            if (blobManager.deleteBlob(blobCode)) continue;
            logger.warn("Could not delete blob " + blobCode);
        }
    }

    public static void recordBlob(Blob blob) {
        if (blob == null) {
            return;
        }
        HttpSession session = ElementsThreadLocals.getHttpServletRequest().getSession();
        Set blobs = (Set)session.getAttribute(SESSION_ATTRIBUTE);
        blobs.add(blob.getCode());
    }

    public static void forgetBlob(Blob blob) {
        if (blob == null) {
            return;
        }
        HttpSession session = ElementsThreadLocals.getHttpServletRequest().getSession();
        Set blobs = (Set)session.getAttribute(SESSION_ATTRIBUTE);
        blobs.remove(blob.getCode());
    }
}

