/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.reflection;

import com.manydesigns.portofino.model.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnnotatedAccessor
implements AnnotatedElement {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected final Map<Class, java.lang.annotation.Annotation> annotations = new HashMap<Class, java.lang.annotation.Annotation>();
    public static final Logger logger = LoggerFactory.getLogger(AbstractAnnotatedAccessor.class);

    public AbstractAnnotatedAccessor(@Nullable Collection<Annotation> annotations) {
        if (annotations == null) {
            return;
        }
        for (Annotation annotation : annotations) {
            Class annotationClass = annotation.getJavaAnnotationClass();
            java.lang.annotation.Annotation javaAnnotation = annotation.getJavaAnnotation();
            this.annotations.put(annotationClass, javaAnnotation);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    public <T extends java.lang.annotation.Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotations.get(annotationClass);
    }

    @Override
    public java.lang.annotation.Annotation[] getAnnotations() {
        Collection<java.lang.annotation.Annotation> annotationCollection = this.annotations.values();
        java.lang.annotation.Annotation[] result = new java.lang.annotation.Annotation[annotationCollection.size()];
        annotationCollection.toArray(result);
        return result;
    }

    @Override
    public java.lang.annotation.Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }
}

