/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.persistence;

import com.manydesigns.elements.fields.search.BaseCriteria;
import com.manydesigns.elements.fields.search.Criterion;
import com.manydesigns.elements.fields.search.TextMatchMode;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.text.OgnlSqlFormat;
import com.manydesigns.elements.text.QueryStringWithParameters;
import com.manydesigns.portofino.database.TableCriteria;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.ForeignKey;
import com.manydesigns.portofino.model.database.Reference;
import com.manydesigns.portofino.persistence.Persistence;
import com.manydesigns.portofino.reflection.TableAccessor;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.Work;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtils {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected static final String WHERE_STRING = " WHERE ";
    protected static final Pattern FROM_PATTERN = Pattern.compile("(SELECT\\s+.*\\s+)?FROM\\s+([a-z_$\\u0080-\\ufffe]{1}[a-z_$0-9\\u0080-\\ufffe]*).*", 34);
    protected static final Logger logger = LoggerFactory.getLogger(QueryUtils.class);
    public static final String FAKE_SELECT_PREFIX = "select __portofino_fake_select__ ";

    public static List<Object[]> runSql(Session session, String sql) {
        OgnlSqlFormat sqlFormat = OgnlSqlFormat.create((String)sql);
        String formatString = sqlFormat.getFormatString();
        Object[] parameters = sqlFormat.evaluateOgnlExpressions(null);
        return QueryUtils.runSql(session, formatString, parameters);
    }

    public static List<Object[]> runSql(Session session, final String queryString, final Object[] parameters) {
        final ArrayList<Object[]> result = new ArrayList<Object[]>();
        try {
            session.doWork(new Work(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(Connection connection) throws SQLException {
                    PreparedStatement stmt = connection.prepareStatement(queryString);
                    try {
                        for (int i = 0; i < parameters.length; ++i) {
                            stmt.setObject(i + 1, parameters[i]);
                        }
                        ResultSet rs = stmt.executeQuery();
                        ResultSetMetaData md = rs.getMetaData();
                        int cc = md.getColumnCount();
                        while (rs.next()) {
                            Object[] current = new Object[cc];
                            for (int i = 0; i < cc; ++i) {
                                current[i] = rs.getObject(i + 1);
                            }
                            result.add(current);
                        }
                    }
                    finally {
                        stmt.close();
                    }
                }
            });
        }
        catch (HibernateException e) {
            session.getTransaction().rollback();
            session.beginTransaction();
            throw e;
        }
        return result;
    }

    public static List<Object> getObjects(Session session, TableCriteria criteria, @Nullable Integer firstResult, @Nullable Integer maxResults) {
        QueryStringWithParameters queryStringWithParameters = QueryUtils.getQueryStringWithParametersForCriteria(criteria);
        return QueryUtils.runHqlQuery(session, queryStringWithParameters.getQueryString(), queryStringWithParameters.getParameters(), firstResult, maxResults);
    }

    public static List<Object> getObjects(Session session, String queryString, Object rootObject, @Nullable Integer firstResult, @Nullable Integer maxResults) {
        OgnlSqlFormat sqlFormat = OgnlSqlFormat.create((String)queryString);
        String formatString = sqlFormat.getFormatString();
        Object[] parameters = sqlFormat.evaluateOgnlExpressions(rootObject);
        return QueryUtils.runHqlQuery(session, formatString, parameters, firstResult, maxResults);
    }

    public static List<Object> getObjects(Session session, String queryString, @Nullable Integer firstResult, @Nullable Integer maxResults) {
        return QueryUtils.getObjects(session, queryString, null, null, firstResult, maxResults);
    }

    public static QueryStringWithParameters getQueryStringWithParametersForCriteria(TableCriteria criteria) {
        return QueryUtils.getQueryStringWithParametersForCriteria(criteria, null);
    }

    public static QueryStringWithParameters getQueryStringWithParametersForCriteria(@Nullable TableCriteria criteria, @Nullable String alias) {
        if (criteria == null) {
            return new QueryStringWithParameters("", new Object[0]);
        }
        com.manydesigns.portofino.model.database.Table table = criteria.getTable();
        ArrayList<Object> parametersList = new ArrayList<Object>();
        StringBuilder whereBuilder = new StringBuilder();
        Iterator i$ = criteria.iterator();
        while (i$.hasNext()) {
            String pattern;
            BaseCriteria.GtCriterion gtCriterion;
            String hqlFormat;
            Object value;
            Criterion criterion = (Criterion)i$.next();
            PropertyAccessor accessor = criterion.getPropertyAccessor();
            if (criterion instanceof BaseCriteria.EqCriterion) {
                BaseCriteria.EqCriterion eqCriterion = (BaseCriteria.EqCriterion)criterion;
                value = eqCriterion.getValue();
                hqlFormat = "{0} = ?";
                parametersList.add(value);
            } else if (criterion instanceof BaseCriteria.InCriterion) {
                BaseCriteria.InCriterion inCriterion = (BaseCriteria.InCriterion)criterion;
                Object[] values = inCriterion.getValues();
                StringBuilder params = new StringBuilder();
                if (values != null) {
                    boolean first = true;
                    for (Object value2 : values) {
                        if (!first) {
                            params.append(", ?");
                        } else {
                            params.append("?");
                            first = false;
                        }
                        parametersList.add(value2);
                    }
                    hqlFormat = "{0} in (" + params.toString() + ")";
                } else {
                    hqlFormat = null;
                }
            } else if (criterion instanceof BaseCriteria.NeCriterion) {
                BaseCriteria.NeCriterion neCriterion = (BaseCriteria.NeCriterion)criterion;
                value = neCriterion.getValue();
                hqlFormat = "{0} <> ?";
                parametersList.add(value);
            } else if (criterion instanceof BaseCriteria.BetweenCriterion) {
                BaseCriteria.BetweenCriterion betweenCriterion = (BaseCriteria.BetweenCriterion)criterion;
                Object min = betweenCriterion.getMin();
                Object max = betweenCriterion.getMax();
                hqlFormat = "{0} >= ? AND {0} <= ?";
                parametersList.add(min);
                parametersList.add(max);
            } else if (criterion instanceof BaseCriteria.GtCriterion) {
                gtCriterion = (BaseCriteria.GtCriterion)criterion;
                value = gtCriterion.getValue();
                hqlFormat = "{0} > ?";
                parametersList.add(value);
            } else if (criterion instanceof BaseCriteria.GeCriterion) {
                gtCriterion = (BaseCriteria.GeCriterion)criterion;
                value = gtCriterion.getValue();
                hqlFormat = "{0} >= ?";
                parametersList.add(value);
            } else if (criterion instanceof BaseCriteria.LtCriterion) {
                BaseCriteria.LtCriterion ltCriterion = (BaseCriteria.LtCriterion)criterion;
                value = ltCriterion.getValue();
                hqlFormat = "{0} < ?";
                parametersList.add(value);
            } else if (criterion instanceof BaseCriteria.LeCriterion) {
                BaseCriteria.LeCriterion leCriterion = (BaseCriteria.LeCriterion)criterion;
                value = leCriterion.getValue();
                hqlFormat = "{0} <= ?";
                parametersList.add(value);
            } else if (criterion instanceof BaseCriteria.LikeCriterion) {
                BaseCriteria.LikeCriterion likeCriterion = (BaseCriteria.LikeCriterion)criterion;
                value = (String)likeCriterion.getValue();
                pattern = QueryUtils.processTextMatchMode(likeCriterion.getTextMatchMode(), (String)value);
                hqlFormat = "{0} like ?";
                parametersList.add(pattern);
            } else if (criterion instanceof BaseCriteria.IlikeCriterion) {
                BaseCriteria.IlikeCriterion ilikeCriterion = (BaseCriteria.IlikeCriterion)criterion;
                value = (String)ilikeCriterion.getValue();
                pattern = QueryUtils.processTextMatchMode(ilikeCriterion.getTextMatchMode(), (String)value);
                hqlFormat = "lower({0}) like lower(?)";
                parametersList.add(pattern);
            } else if (criterion instanceof BaseCriteria.IsNullCriterion) {
                hqlFormat = "{0} is null";
            } else if (criterion instanceof BaseCriteria.IsNotNullCriterion) {
                hqlFormat = "{0} is not null";
            } else {
                logger.error("Unrecognized criterion: {}", (Object)criterion);
                throw new InternalError("Unrecognied criterion");
            }
            if (hqlFormat == null) continue;
            String accessorName = accessor.getName();
            if (alias != null) {
                accessorName = alias + "." + accessorName;
            }
            String hql = MessageFormat.format(hqlFormat, accessorName);
            if (whereBuilder.length() > 0) {
                whereBuilder.append(" AND ");
            }
            whereBuilder.append(hql);
        }
        String whereClause = whereBuilder.toString();
        String actualEntityName = table.getActualEntityName();
        if (alias != null) {
            actualEntityName = actualEntityName + " " + alias;
        }
        String queryString = whereClause.length() > 0 ? MessageFormat.format("FROM {0} WHERE {1}", actualEntityName, whereClause) : MessageFormat.format("FROM {0}", actualEntityName);
        Object[] parameters = new Object[parametersList.size()];
        parametersList.toArray(parameters);
        return new QueryStringWithParameters(queryString, parameters);
    }

    protected static String processTextMatchMode(TextMatchMode textMatchMode, String value) {
        String pattern;
        switch (textMatchMode) {
            case EQUALS: {
                pattern = value;
                break;
            }
            case CONTAINS: {
                pattern = "%" + value + "%";
                break;
            }
            case STARTS_WITH: {
                pattern = value + "%";
                break;
            }
            case ENDS_WITH: {
                pattern = "%" + value;
                break;
            }
            default: {
                String msg = MessageFormat.format("Unrecognized text match mode: {0}", textMatchMode);
                logger.error(msg);
                throw new InternalError(msg);
            }
        }
        return pattern;
    }

    public static com.manydesigns.portofino.model.database.Table getTableFromQueryString(Database database, String queryString) {
        Matcher matcher = FROM_PATTERN.matcher(queryString);
        if (!matcher.matches()) {
            return null;
        }
        String entityName = matcher.group(2);
        com.manydesigns.portofino.model.database.Table table = DatabaseLogic.findTableByEntityName(database, entityName);
        return table;
    }

    public static List<Object> getObjects(Session session, String queryString, TableCriteria criteria, @Nullable Object rootObject, @Nullable Integer firstResult, @Nullable Integer maxResults) {
        QueryStringWithParameters result = QueryUtils.mergeQuery(queryString, criteria, rootObject);
        return QueryUtils.runHqlQuery(session, result.getQueryString(), result.getParameters(), firstResult, maxResults);
    }

    public static QueryStringWithParameters mergeQuery(String queryString, @Nullable TableCriteria criteria, Object rootObject) {
        String fullQueryString;
        Expression whereExpression;
        PlainSelect parsedCriteriaQuery;
        PlainSelect parsedQueryString;
        OgnlSqlFormat sqlFormat = OgnlSqlFormat.create((String)queryString);
        String formatString = sqlFormat.getFormatString();
        Object[] parameters = sqlFormat.evaluateOgnlExpressions(rootObject);
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        try {
            parsedQueryString = QueryUtils.parseQuery(parserManager, formatString);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException("Couldn't merge query", e);
        }
        String mainEntityAlias = null;
        if (criteria != null) {
            mainEntityAlias = QueryUtils.getEntityAlias(criteria.getTable().getActualEntityName(), parsedQueryString);
        }
        QueryStringWithParameters criteriaQuery = QueryUtils.getQueryStringWithParametersForCriteria(criteria, mainEntityAlias);
        String criteriaQueryString = criteriaQuery.getQueryString();
        Object[] criteriaParameters = criteriaQuery.getParameters();
        try {
            parsedCriteriaQuery = StringUtils.isEmpty((String)criteriaQueryString) ? new PlainSelect() : QueryUtils.parseQuery(parserManager, criteriaQueryString);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException("Couldn't merge query", e);
        }
        if (parsedQueryString.getWhere() != null) {
            if (parsedCriteriaQuery.getWhere() != null) {
                whereExpression = parsedQueryString.getWhere();
                if (!(whereExpression instanceof Parenthesis)) {
                    whereExpression = new Parenthesis(whereExpression);
                }
                whereExpression = new AndExpression(whereExpression, parsedCriteriaQuery.getWhere());
            } else {
                whereExpression = parsedQueryString.getWhere();
            }
        } else {
            whereExpression = parsedCriteriaQuery.getWhere();
        }
        parsedQueryString.setWhere(whereExpression);
        if (criteria != null && criteria.getOrderBy() != null) {
            ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>();
            OrderByElement orderByElement = new OrderByElement();
            orderByElement.setAsc(criteria.getOrderBy().isAsc());
            String propertyName = criteria.getOrderBy().getPropertyAccessor().getName();
            if (mainEntityAlias != null) {
                propertyName = mainEntityAlias + "." + propertyName;
            }
            orderByElement.setExpression((Expression)new net.sf.jsqlparser.schema.Column(new Table(), propertyName));
            orderByElements.add(orderByElement);
            if (parsedQueryString.getOrderByElements() != null) {
                for (Object el : parsedQueryString.getOrderByElements()) {
                    net.sf.jsqlparser.schema.Column column;
                    OrderByElement toAdd = (OrderByElement)el;
                    if (toAdd.getExpression() instanceof net.sf.jsqlparser.schema.Column && StringUtils.isEmpty((String)(column = (net.sf.jsqlparser.schema.Column)toAdd.getExpression()).getTable().getName()) && propertyName.equals(column.getColumnName())) continue;
                    orderByElements.add(toAdd);
                }
            }
            parsedQueryString.setOrderByElements(orderByElements);
        }
        if ((fullQueryString = parsedQueryString.toString()).toLowerCase().startsWith(FAKE_SELECT_PREFIX)) {
            fullQueryString = fullQueryString.substring(FAKE_SELECT_PREFIX.length());
        }
        ArrayList<Object> mergedParametersList = new ArrayList<Object>();
        mergedParametersList.addAll(Arrays.asList(parameters));
        mergedParametersList.addAll(Arrays.asList(criteriaParameters));
        Object[] mergedParameters = new Object[mergedParametersList.size()];
        mergedParametersList.toArray(mergedParameters);
        return new QueryStringWithParameters(fullQueryString, mergedParameters);
    }

    public static PlainSelect parseQuery(CCJSqlParserManager parserManager, String query) throws JSQLParserException {
        if (!query.toLowerCase().trim().startsWith("select")) {
            query = FAKE_SELECT_PREFIX + query;
        }
        PlainSelect parsedQueryString = (PlainSelect)((Select)parserManager.parse((Reader)new StringReader(query))).getSelectBody();
        return parsedQueryString;
    }

    public static List<Object> runHqlQuery(Session session, String queryString, @Nullable Object[] parameters) {
        return QueryUtils.runHqlQuery(session, queryString, parameters, null, null);
    }

    public static List<Object> runHqlQuery(Session session, String queryString, @Nullable Object[] parameters, @Nullable Integer firstResult, @Nullable Integer maxResults) {
        Query query = session.createQuery(queryString);
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                query.setParameter(i, parameters[i]);
            }
        }
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        try {
            List result = query.list();
            return result;
        }
        catch (HibernateException e) {
            logger.error("Error running query", (Throwable)e);
            session.getTransaction().rollback();
            session.beginTransaction();
            throw e;
        }
    }

    public static Object getObjectByPk(Persistence persistence, String database, String entityName, Serializable pk) {
        Session session = persistence.getSession(database);
        TableAccessor table = persistence.getTableAccessor(database, entityName);
        return QueryUtils.getObjectByPk(session, table, pk);
    }

    public static Object getObjectByPk(Session session, TableAccessor table, Serializable pk) {
        String actualEntityName = table.getTable().getActualEntityName();
        PropertyAccessor[] keyProperties = table.getKeyProperties();
        int size = keyProperties.length;
        if (size > 1) {
            Object result = session.get(actualEntityName, pk);
            return result;
        }
        PropertyAccessor propertyAccessor = keyProperties[0];
        Serializable key = (Serializable)propertyAccessor.get((Object)pk);
        Object result = session.get(actualEntityName, key);
        return result;
    }

    public static Object getObjectByPk(Persistence persistence, com.manydesigns.portofino.model.database.Table baseTable, Serializable pkObject) {
        return QueryUtils.getObjectByPk(persistence, baseTable.getDatabaseName(), baseTable.getActualEntityName(), pkObject);
    }

    public static Object getObjectByPk(Persistence persistence, com.manydesigns.portofino.model.database.Table baseTable, Serializable pkObject, String query, Object rootObject) {
        return QueryUtils.getObjectByPk(persistence, baseTable.getDatabaseName(), baseTable.getActualEntityName(), pkObject, query, rootObject);
    }

    public static Object getObjectByPk(Persistence persistence, String database, String entityName, Serializable pk, String hqlQueryString, Object rootObject) {
        TableAccessor table = persistence.getTableAccessor(database, entityName);
        PropertyAccessor[] keyProperties = table.getKeyProperties();
        OgnlSqlFormat sqlFormat = OgnlSqlFormat.create((String)hqlQueryString);
        String formatString = sqlFormat.getFormatString();
        Object[] ognlParameters = sqlFormat.evaluateOgnlExpressions(rootObject);
        int i = keyProperties.length;
        int p = ognlParameters.length;
        Object[] parameters = new Object[p + i];
        System.arraycopy(ognlParameters, 0, parameters, i, p);
        try {
            Session session;
            List<Object> result;
            PlainSelect parsedQuery = QueryUtils.parseQuery(new CCJSqlParserManager(), formatString);
            if (parsedQuery.getWhere() == null) {
                return QueryUtils.getObjectByPk(persistence, database, entityName, pk);
            }
            String mainEntityAlias = QueryUtils.getEntityAlias(entityName, parsedQuery);
            Table mainEntityTable = mainEntityAlias != null ? new Table(null, mainEntityAlias) : new Table();
            for (PropertyAccessor propertyAccessor : keyProperties) {
                --i;
                EqualsTo condition = new EqualsTo();
                parsedQuery.setWhere((Expression)new AndExpression((Expression)condition, (Expression)new Parenthesis(parsedQuery.getWhere())));
                net.sf.jsqlparser.schema.Column column = new net.sf.jsqlparser.schema.Column(mainEntityTable, propertyAccessor.getName());
                condition.setLeftExpression((Expression)column);
                condition.setRightExpression((Expression)new JdbcParameter());
                parameters[i] = propertyAccessor.get((Object)pk);
            }
            String fullQueryString = parsedQuery.toString();
            if (fullQueryString.toLowerCase().startsWith(FAKE_SELECT_PREFIX)) {
                fullQueryString = fullQueryString.substring(FAKE_SELECT_PREFIX.length());
            }
            if ((result = QueryUtils.runHqlQuery(session = persistence.getSession(database), fullQueryString, parameters)) != null && !result.isEmpty()) {
                return result.get(0);
            }
            return null;
        }
        catch (JSQLParserException e) {
            throw new Error(e);
        }
    }

    protected static String getEntityAlias(String entityName, PlainSelect query) {
        FromItem fromItem = query.getFromItem();
        if (QueryUtils.hasEntityAlias(entityName, fromItem)) {
            return fromItem.getAlias().getName();
        }
        if (query.getJoins() != null) {
            for (Object o : query.getJoins()) {
                Join join = (Join)o;
                if (!QueryUtils.hasEntityAlias(entityName, join.getRightItem())) continue;
                return join.getRightItem().getAlias().getName();
            }
        }
        logger.debug("Alias from entity " + entityName + " not found in query " + query);
        return null;
    }

    private static boolean hasEntityAlias(String entityName, FromItem fromItem) {
        return fromItem instanceof Table && ((Table)fromItem).getName().equals(entityName) && fromItem.getAlias() != null && !StringUtils.isBlank((String)fromItem.getAlias().getName());
    }

    public static void commit(Persistence persistence, String databaseName) {
        Session session = persistence.getSession(databaseName);
        try {
            session.getTransaction().commit();
        }
        catch (HibernateException e) {
            persistence.closeSession(databaseName);
            throw e;
        }
    }

    public static List<Object> getRelatedObjects(Persistence persistence, String databaseName, String entityName, Object obj, String oneToManyRelationshipName) {
        Model model = persistence.getModel();
        ForeignKey relationship = DatabaseLogic.findOneToManyRelationship(model, databaseName, entityName, oneToManyRelationshipName);
        if (relationship == null) {
            throw new IllegalArgumentException("Relationship not defined: " + oneToManyRelationshipName);
        }
        com.manydesigns.portofino.model.database.Table fromTable = relationship.getFromTable();
        Session session = persistence.getSession(fromTable.getDatabaseName());
        TableAccessor toAccessor = persistence.getTableAccessor(databaseName, entityName);
        try {
            Criteria criteria = session.createCriteria(fromTable.getActualEntityName());
            for (Reference reference : relationship.getReferences()) {
                Column fromColumn = reference.getActualFromColumn();
                Column toColumn = reference.getActualToColumn();
                PropertyAccessor toPropertyAccessor = toAccessor.getProperty(toColumn.getActualPropertyName());
                Object toValue = toPropertyAccessor.get(obj);
                criteria.add((org.hibernate.criterion.Criterion)Restrictions.eq((String)fromColumn.getActualPropertyName(), (Object)toValue));
            }
            List result = criteria.list();
            return result;
        }
        catch (Throwable e) {
            String msg = String.format("Cannot access relationship %s on entity %s.%s", oneToManyRelationshipName, databaseName, entityName);
            logger.warn(msg, e);
            return null;
        }
    }
}

