/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.elements.annotations.Required;
import com.manydesigns.elements.util.ReflectionUtil;
import com.manydesigns.portofino.model.Annotated;
import com.manydesigns.portofino.model.Annotation;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.DatabaseSelectionProvider;
import com.manydesigns.portofino.model.database.ForeignKey;
import com.manydesigns.portofino.model.database.ModelSelectionProvider;
import com.manydesigns.portofino.model.database.PrimaryKey;
import com.manydesigns.portofino.model.database.Schema;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Table
implements ModelObject,
Annotated {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    protected final List<Column> columns = new ArrayList<Column>();
    protected final List<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
    protected final List<Annotation> annotations;
    protected final List<ModelSelectionProvider> selectionProviders;
    protected Schema schema;
    protected String tableName;
    protected String entityName;
    protected String javaClass;
    protected String shortName;
    protected PrimaryKey primaryKey;
    protected final List<ForeignKey> oneToManyRelationships = new ArrayList<ForeignKey>();
    protected Class actualJavaClass;
    protected String actualEntityName;
    public static final Logger logger = LoggerFactory.getLogger(Table.class);

    public Table() {
        this.annotations = new ArrayList<Annotation>();
        this.selectionProviders = new ArrayList<ModelSelectionProvider>();
    }

    public Table(Schema schema) {
        this();
        this.schema = schema;
    }

    public String getQualifiedName() {
        return MessageFormat.format("{0}.{1}", this.schema.getQualifiedName(), this.tableName);
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.schema = (Schema)parent;
    }

    @Override
    public void reset() {
        this.actualEntityName = null;
        this.actualJavaClass = null;
        this.oneToManyRelationships.clear();
    }

    @Override
    public void init(Model model) {
        assert (this.schema != null);
        assert (this.tableName != null);
        this.actualJavaClass = ReflectionUtil.loadClass((String)this.javaClass);
        String baseEntityName = this.entityName == null ? DatabaseLogic.normalizeName(this.getTableName()) : DatabaseLogic.normalizeName(this.entityName);
        String calculatedEntityName = baseEntityName;
        int i = 2;
        Database database = this.schema.getDatabase();
        while (DatabaseLogic.findTableByEntityName(database, calculatedEntityName) != null) {
            logger.warn("Entity name {} already taken, generating a new one", (Object)calculatedEntityName);
            calculatedEntityName = baseEntityName + "_" + i++;
        }
        this.actualEntityName = calculatedEntityName;
    }

    @Override
    public void link(Model model) {
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
        for (Column column : this.columns) {
            visitor.visit(column);
        }
        if (this.primaryKey == null) {
            logger.warn("Table {} has no primary key", (Object)this.toString());
        } else {
            visitor.visit(this.primaryKey);
        }
        for (ForeignKey foreignKey : this.foreignKeys) {
            visitor.visit(foreignKey);
        }
        for (Annotation annotation : this.annotations) {
            visitor.visit(annotation);
        }
        for (ModelSelectionProvider selectionProvider : this.selectionProviders) {
            visitor.visit(selectionProvider);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Required
    public String getDatabaseName() {
        return this.schema.getDatabaseName();
    }

    @Required
    public String getSchemaName() {
        return this.schema.getSchemaName();
    }

    @Required
    @XmlAttribute(required=true)
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @XmlAttribute(required=false)
    public String getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(String javaClass) {
        this.javaClass = javaClass;
    }

    @XmlElementWrapper(name="columns")
    @XmlElement(name="column", type=Column.class)
    public List<Column> getColumns() {
        return this.columns;
    }

    @XmlElement
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Class getActualJavaClass() {
        return this.actualJavaClass;
    }

    @XmlElementWrapper(name="foreignKeys")
    @XmlElement(name="foreignKey", type=ForeignKey.class)
    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @XmlAttribute(required=false)
    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getActualEntityName() {
        return this.actualEntityName;
    }

    public List<ForeignKey> getOneToManyRelationships() {
        return this.oneToManyRelationships;
    }

    @Override
    @XmlElementWrapper(name="annotations")
    @XmlElement(name="annotation", type=Annotation.class)
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @XmlElementWrapper(name="selectionProviders")
    @XmlElement(name="query", type=DatabaseSelectionProvider.class)
    public List<ModelSelectionProvider> getSelectionProviders() {
        return this.selectionProviders;
    }

    @XmlAttribute(required=false)
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String toString() {
        return MessageFormat.format("table {0}", this.getQualifiedName());
    }

    public static String composeQualifiedName(String databaseName, String schemaName, String tableName) {
        return MessageFormat.format("{0}.{1}.{2}", databaseName, schemaName, tableName);
    }
}

