/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.portofino.model.Annotated;
import com.manydesigns.portofino.model.Annotation;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.model.database.ForeignKey;
import com.manydesigns.portofino.model.database.ModelSelectionProvider;
import com.manydesigns.portofino.model.database.Reference;
import com.manydesigns.portofino.model.database.Schema;
import com.manydesigns.portofino.model.database.Table;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseLogic {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(DatabaseLogic.class);
    public static final String[] HQL_KEYWORDS = new String[]{"member", "order", "group", "select", "insert", "update", "from"};

    public static List<Schema> getAllSchemas(Model model) {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Database database : model.getDatabases()) {
            for (Schema schema : database.getSchemas()) {
                result.add(schema);
            }
        }
        return result;
    }

    public static List<Table> getAllTables(Model model) {
        ArrayList<Table> result = new ArrayList<Table>();
        for (Database database : model.getDatabases()) {
            for (Schema schema : database.getSchemas()) {
                for (Table table : schema.getTables()) {
                    result.add(table);
                }
            }
        }
        return result;
    }

    public static List<Column> getAllColumns(Model model) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Database database : model.getDatabases()) {
            for (Schema schema : database.getSchemas()) {
                for (Table table : schema.getTables()) {
                    for (Column column : table.getColumns()) {
                        result.add(column);
                    }
                }
            }
        }
        return result;
    }

    public static List<ForeignKey> getAllForeignKeys(Model model) {
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        for (Database database : model.getDatabases()) {
            for (Schema schema : database.getSchemas()) {
                for (Table table : schema.getTables()) {
                    for (ForeignKey foreignKey : table.getForeignKeys()) {
                        result.add(foreignKey);
                    }
                }
            }
        }
        return result;
    }

    @Nullable
    public static Database findDatabaseByName(Model model, String databaseName) {
        for (Database database : model.getDatabases()) {
            if (!database.getDatabaseName().equals(databaseName)) continue;
            return database;
        }
        logger.debug("Database not found: {}", (Object)databaseName);
        return null;
    }

    @Nullable
    public static Schema findSchemaByName(Database database, String schemaName) {
        for (Schema schema : database.getSchemas()) {
            if (!schema.getSchemaName().equals(schemaName)) continue;
            return schema;
        }
        logger.debug("Schema not found: {}", (Object)schemaName);
        return null;
    }

    @Nullable
    public static Schema findSchemaByNameIgnoreCase(Database database, String schemaName) {
        for (Schema schema : database.getSchemas()) {
            if (!schema.getSchemaName().equalsIgnoreCase(schemaName)) continue;
            return schema;
        }
        logger.debug("Schema not found: {}", (Object)schemaName);
        return null;
    }

    @Nullable
    public static Schema findSchemaByName(Model model, String databaseName, String schemaName) {
        Database database = DatabaseLogic.findDatabaseByName(model, databaseName);
        if (database != null) {
            return DatabaseLogic.findSchemaByName(database, schemaName);
        }
        logger.debug("Schema not found: {}", (Object)schemaName);
        return null;
    }

    @Nullable
    public static Table findTableByName(Model model, String databaseName, String schemaName, String tableName) {
        Schema schema = DatabaseLogic.findSchemaByName(model, databaseName, schemaName);
        if (schema != null) {
            return DatabaseLogic.findTableByName(schema, tableName);
        }
        logger.debug("Table not found: {}", (Object)tableName);
        return null;
    }

    @Nullable
    public static Table findTableByName(Schema schema, String tableName) {
        for (Table table : schema.getTables()) {
            if (!table.getTableName().equals(tableName)) continue;
            return table;
        }
        logger.debug("Table {} not found in {}", (Object)tableName, (Object)schema);
        return null;
    }

    @Nullable
    public static Table findTableByNameIgnoreCase(Schema schema, String tableName) {
        for (Table table : schema.getTables()) {
            if (!table.getTableName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        logger.debug("Table {} not found in {}", (Object)tableName, (Object)schema);
        return null;
    }

    @Nullable
    public static Column findColumnByName(Table table, String columnName) {
        for (Column column : table.getColumns()) {
            if (!column.getColumnName().equals(columnName)) continue;
            return column;
        }
        logger.debug("Column {} not found in {}", (Object)columnName, (Object)table);
        return null;
    }

    @Nullable
    public static Column findColumnByNameIgnoreCase(Table table, String columnName) {
        for (Column column : table.getColumns()) {
            if (!column.getColumnName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        logger.debug("Column {} not found in {}", (Object)columnName, (Object)table);
        return null;
    }

    public static Column findColumnByPropertyName(Table table, String propertyName) {
        for (Column column : table.getColumns()) {
            if (!column.getActualPropertyName().equals(propertyName)) continue;
            return column;
        }
        logger.debug("Property {} not found in {}", (Object)propertyName, (Object)table);
        return null;
    }

    @Nullable
    public static Column findColumnByName(Model model, String databaseName, String schemaName, String tableName, String columnName) {
        Table table = DatabaseLogic.findTableByName(model, databaseName, schemaName, tableName);
        if (table != null) {
            for (Column column : table.getColumns()) {
                if (!column.getColumnName().equals(columnName)) continue;
                return column;
            }
        }
        logger.debug("Column not found: {}", (Object)columnName);
        return null;
    }

    @Nullable
    public static ForeignKey findOneToManyRelationship(Model model, String databaseName, String entityName, String relationshipName) {
        Database database = DatabaseLogic.findDatabaseByName(model, databaseName);
        Table table = DatabaseLogic.findTableByEntityName(database, entityName);
        assert (table != null);
        return DatabaseLogic.findOneToManyRelationshipByName(table, relationshipName);
    }

    public static Table findTableByEntityName(Database database, String entityName) {
        for (Schema schema : database.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (!entityName.equals(table.getActualEntityName())) continue;
                return table;
            }
        }
        return null;
    }

    public static ForeignKey findForeignKeyByName(Table table, String fkName) {
        for (ForeignKey current : table.foreignKeys) {
            if (!current.getName().equals(fkName)) continue;
            return current;
        }
        logger.debug("Foreign key not found: {}", (Object)fkName);
        return null;
    }

    public static ForeignKey findForeignKeyByNameIgnoreCase(Table table, String fkName) {
        for (ForeignKey current : table.foreignKeys) {
            if (!current.getName().equalsIgnoreCase(fkName)) continue;
            return current;
        }
        logger.debug("Foreign key not found: {}", (Object)fkName);
        return null;
    }

    public static ModelSelectionProvider findSelectionProviderByName(Table table, String selectionProviderName) {
        for (ModelSelectionProvider current : table.selectionProviders) {
            if (!current.getName().equalsIgnoreCase(selectionProviderName)) continue;
            return current;
        }
        logger.debug("Selection provider not found: {}", (Object)selectionProviderName);
        return null;
    }

    public static ForeignKey findOneToManyRelationshipByName(Table table, String relationshipName) {
        for (ForeignKey current : table.getOneToManyRelationships()) {
            if (!current.getName().equalsIgnoreCase(relationshipName)) continue;
            return current;
        }
        Table.logger.debug("One to many relationship not found: {}", (Object)relationshipName);
        return null;
    }

    public static String[] splitQualifiedTableName(String qualifiedName) {
        String[] name = qualifiedName.split("\\.");
        if (name.length == 3) {
            return name;
        }
        throw new IllegalArgumentException("Not a qualified table name: " + qualifiedName);
    }

    public static Annotation findAnnotation(Annotated object, Class<? extends java.lang.annotation.Annotation> annotationClass) {
        for (Annotation candidate : object.getAnnotations()) {
            if (!candidate.getType().equals(annotationClass.getName())) continue;
            return candidate;
        }
        return null;
    }

    public static String getUniquePropertyName(Table table, String initialName) {
        String prefix = initialName;
        int prog = 2;
        boolean changed = true;
        block0: while (changed) {
            changed = false;
            for (Column column : table.getColumns()) {
                if (!StringUtils.equals((String)initialName, (String)column.getActualPropertyName())) continue;
                initialName = prefix + "_" + prog;
                logger.warn("Duplicate property found, renaming to {}", (Object)initialName);
                ++prog;
                changed = true;
                break;
            }
            if (!changed) {
                for (ForeignKey fk : table.getForeignKeys()) {
                    if (!StringUtils.equals((String)initialName, (String)fk.getActualOnePropertyName())) continue;
                    initialName = prefix + "_" + prog;
                    logger.warn("Duplicate property found, renaming to {}", (Object)initialName);
                    ++prog;
                    changed = true;
                    break;
                }
            }
            if (changed) continue;
            for (ForeignKey fk : table.getOneToManyRelationships()) {
                if (!StringUtils.equals((String)initialName, (String)fk.getActualManyPropertyName())) continue;
                initialName = prefix + "_" + prog;
                logger.warn("Duplicate property found, renaming to {}", (Object)initialName);
                ++prog;
                changed = true;
                continue block0;
            }
        }
        return initialName;
    }

    public static boolean isInPk(Column column) {
        return column.getTable().getPrimaryKey().getColumns().contains(column);
    }

    public static boolean isInFk(Column column) {
        Table table = column.getTable();
        for (ForeignKey fk : table.getForeignKeys()) {
            for (Reference ref : fk.getReferences()) {
                if (!ref.getActualFromColumn().equals(column)) continue;
                return true;
            }
        }
        return false;
    }

    public static String normalizeName(String name) {
        name = StringUtils.replaceChars((String)name, (String)".", (String)"_");
        String firstLetter = name.substring(0, 1);
        String others = name.substring(1);
        StringBuilder result = new StringBuilder();
        result.append(DatabaseLogic.checkFirstLetter(firstLetter));
        for (int i = 0; i < others.length(); ++i) {
            String letter = String.valueOf(others.charAt(i));
            result.append(DatabaseLogic.checkOtherLetters(letter));
        }
        String normalizedName = result.toString();
        if (ArrayUtils.contains((Object[])HQL_KEYWORDS, (Object)normalizedName.toLowerCase())) {
            normalizedName = "_" + normalizedName;
        }
        if (!name.equals(normalizedName)) {
            logger.info("Name " + name + " normalized to " + normalizedName);
        }
        return normalizedName;
    }

    static String checkFirstLetter(String letter) {
        if ((letter = StringUtils.replaceChars((String)letter, (String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ", (String)"abcdefghijklmnopqrstuvwxyz")).equals("_") || letter.equals("$") || StringUtils.isAlpha((String)letter)) {
            return letter;
        }
        if (StringUtils.isNumeric((String)letter)) {
            return "_" + letter;
        }
        return "_";
    }

    static String checkOtherLetters(String letter) {
        if ((letter = StringUtils.replaceChars((String)letter, (String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ", (String)"abcdefghijklmnopqrstuvwxyz")).equals("_") || letter.equals("$") || StringUtils.isAlphanumeric((String)letter)) {
            return letter;
        }
        return "_";
    }
}

