/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.liquibase.sqlgenerators;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import liquibase.util.StringUtils;

public class PortofinoSelectFromDatabaseChangeLogLockGenerator
extends AbstractSqlGenerator<SelectFromDatabaseChangeLogLockStatement> {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";

    public int getPriority() {
        return 3;
    }

    public ValidationErrors validate(SelectFromDatabaseChangeLogLockStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors errors = new ValidationErrors();
        errors.checkRequiredField("columnToSelect", (Object)statement.getColumnsToSelect());
        return errors;
    }

    public Sql[] generateSql(SelectFromDatabaseChangeLogLockStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String liquibaseSchema = database.getLiquibaseSchemaName();
        String[] columns = statement.getColumnsToSelect();
        String sql = "SELECT " + StringUtils.join((String[])columns, (String)",") + " FROM " + database.escapeTableName(liquibaseSchema, database.getDatabaseChangeLogLockTableName()) + " WHERE ID = 1";
        if (database instanceof OracleDatabase) {
            sql = sql + " FOR UPDATE";
        }
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
    }
}

