/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Type {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(Type.class);
    protected final String typeName;
    protected final int jdbcType;
    protected final boolean autoincrement;
    protected final Long maximumPrecision;
    protected final String literalPrefix;
    protected final String literalSuffix;
    protected final boolean nullable;
    protected final boolean caseSensitive;
    protected final boolean searchable;
    protected final short minimumScale;
    protected final short maximumScale;
    protected final Boolean precisionRequired;
    protected final Boolean scaleRequired;

    public Type(String typeName, int jdbcType, Long maximumPrecision, String literalPrefix, String literalSuffix, boolean nullable, boolean caseSensitive, boolean searchable, boolean autoincrement, short minimumScale, short maximumScale) {
        this.typeName = typeName;
        this.jdbcType = jdbcType;
        this.maximumPrecision = maximumPrecision;
        this.literalPrefix = literalPrefix;
        this.literalSuffix = literalSuffix;
        this.nullable = nullable;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.autoincrement = autoincrement;
        this.minimumScale = minimumScale;
        this.maximumScale = maximumScale;
        this.precisionRequired = null;
        this.scaleRequired = null;
    }

    public Type(String typeName, int jdbcType, Long maximumPrecision, String literalPrefix, String literalSuffix, boolean nullable, boolean caseSensitive, boolean searchable, boolean autoincrement, short minimumScale, short maximumScale, boolean precisionRequired, boolean scaleRequired) {
        this.typeName = typeName;
        this.jdbcType = jdbcType;
        this.maximumPrecision = maximumPrecision;
        this.literalPrefix = literalPrefix;
        this.literalSuffix = literalSuffix;
        this.nullable = nullable;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.autoincrement = autoincrement;
        this.minimumScale = minimumScale;
        this.maximumScale = maximumScale;
        this.precisionRequired = precisionRequired;
        this.scaleRequired = scaleRequired;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public Class getDefaultJavaType() {
        return Type.getDefaultJavaType(this.jdbcType, this.maximumPrecision, this.maximumScale);
    }

    @Nullable
    public static Class getDefaultJavaType(int jdbcType, long precision, int scale) {
        switch (jdbcType) {
            case -5: {
                return Long.class;
            }
            case -7: {
                return Boolean.class;
            }
            case 16: {
                return Boolean.class;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 2: 
            case 3: {
                if (scale > 0) {
                    return BigDecimal.class;
                }
                return Type.getDefaultIntegerType(precision);
            }
            case 8: {
                return Double.class;
            }
            case 7: {
                return Double.class;
            }
            case 6: {
                return Float.class;
            }
            case 4: {
                return Type.getDefaultIntegerType(precision);
            }
            case 5: {
                return Short.class;
            }
            case -6: {
                return Byte.class;
            }
            case -2: {
                return byte[].class;
            }
            case 2004: {
                return Blob.class;
            }
            case 2005: {
                return String.class;
            }
            case -4: {
                return byte[].class;
            }
            case -1: {
                return String.class;
            }
            case -3: {
                return byte[].class;
            }
            case 2003: {
                return Array.class;
            }
            case 70: {
                return URL.class;
            }
            case 2000: 
            case 2001: {
                return Object.class;
            }
            case 0: 
            case 1111: 
            case 2006: {
                return Ref.class;
            }
            case 2002: {
                return Struct.class;
            }
        }
        logger.warn("Unsupported jdbc type: {}", (Object)jdbcType);
        return null;
    }

    public static Class<? extends Number> getDefaultIntegerType(long precision) {
        if ((double)precision < Math.log10(2.147483647E9)) {
            return Integer.class;
        }
        if ((double)precision < Math.log10(9.223372036854776E18)) {
            return Long.class;
        }
        if (precision == 131089L) {
            return BigDecimal.class;
        }
        return BigInteger.class;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public Long getMaximumPrecision() {
        return this.maximumPrecision;
    }

    public String getLiteralPrefix() {
        return this.literalPrefix;
    }

    public String getLiteralSuffix() {
        return this.literalSuffix;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public short getMinimumScale() {
        return this.minimumScale;
    }

    public short getMaximumScale() {
        return this.maximumScale;
    }

    public String toString() {
        return "Type{typeName='" + this.typeName + '\'' + ", jdbcType=" + this.jdbcType + ", autoincrement=" + this.autoincrement + ", maximumPrecision=" + this.maximumPrecision + ", literalPrefix='" + this.literalPrefix + '\'' + ", literalSuffix='" + this.literalSuffix + '\'' + ", nullable=" + this.nullable + ", caseSensitive=" + this.caseSensitive + ", searchable=" + this.searchable + ", minimumScale=" + this.minimumScale + ", maximumScale=" + this.maximumScale + '}';
    }

    public boolean isPrecisionRequired() {
        if (this.precisionRequired != null) {
            return this.precisionRequired;
        }
        switch (this.jdbcType) {
            case -5: {
                return false;
            }
            case -7: {
                return false;
            }
            case 16: {
                return false;
            }
            case 1: {
                return true;
            }
            case 12: {
                return true;
            }
            case 91: {
                return false;
            }
            case 92: {
                return false;
            }
            case 93: {
                return false;
            }
            case 3: {
                return true;
            }
            case 2: {
                return true;
            }
            case 8: {
                return false;
            }
            case 7: {
                return false;
            }
            case 6: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case -6: {
                return false;
            }
            case -2: {
                return false;
            }
            case 2004: {
                return false;
            }
            case 2005: {
                return false;
            }
            case -4: {
                return false;
            }
            case -1: {
                return false;
            }
            case -3: {
                return false;
            }
            case 2003: {
                return false;
            }
            case 70: {
                return false;
            }
            case 2000: 
            case 2001: {
                return false;
            }
            case 0: 
            case 1111: 
            case 2006: {
                return false;
            }
            case 2002: {
                return false;
            }
        }
        return false;
    }

    public boolean isScaleRequired() {
        if (this.scaleRequired != null) {
            return this.scaleRequired;
        }
        switch (this.jdbcType) {
            case -5: {
                return false;
            }
            case -7: {
                return false;
            }
            case 16: {
                return false;
            }
            case 1: {
                return false;
            }
            case 12: {
                return false;
            }
            case 91: {
                return false;
            }
            case 92: {
                return false;
            }
            case 93: {
                return false;
            }
            case 3: {
                return true;
            }
            case 2: {
                return true;
            }
            case 8: {
                return false;
            }
            case 7: {
                return false;
            }
            case 6: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case -6: {
                return false;
            }
            case -2: {
                return false;
            }
            case 2004: {
                return false;
            }
            case 2005: {
                return false;
            }
            case -4: {
                return false;
            }
            case -1: {
                return false;
            }
            case -3: {
                return false;
            }
            case 2003: {
                return false;
            }
            case 70: {
                return false;
            }
            case 2000: 
            case 2001: {
                return false;
            }
            case 0: 
            case 1111: 
            case 2006: {
                return false;
            }
            case 2002: {
                return false;
            }
        }
        return false;
    }

    public boolean isNumeric() {
        switch (this.jdbcType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }
}

