/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.code;

import com.manydesigns.portofino.code.AbstractCodeBase;
import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.code.JavaCodeBase;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyCodeBase
extends AbstractCodeBase {
    protected GroovyScriptEngine groovyScriptEngine;
    private static final Logger logger = LoggerFactory.getLogger(GroovyCodeBase.class);

    public GroovyCodeBase(FileObject root) throws IOException {
        this(root, null, null);
    }

    public GroovyCodeBase(FileObject root, CodeBase parent, ClassLoader classLoader) throws IOException {
        super(root, parent, classLoader);
        this.root = root;
        this.classLoader = classLoader;
        this.resetGroovyScriptEngine();
    }

    public void resetGroovyScriptEngine() throws FileSystemException {
        CompilerConfiguration cc = new CompilerConfiguration(CompilerConfiguration.DEFAULT);
        try {
            String classpath = this.root.getName().getPath();
            cc.setClasspath(classpath);
        }
        catch (Exception e) {
            logger.debug("Could not set classpath", (Throwable)e);
        }
        cc.setRecompileGroovySource(true);
        this.groovyScriptEngine = new GroovyScriptEngine(new URL[]{this.root.getURL()}, this.getClassLoader());
        this.groovyScriptEngine.setConfig(cc);
        this.groovyScriptEngine.getGroovyClassLoader().setShouldRecompile(Boolean.TRUE);
    }

    public GroovyCodeBase(FileObject root, CodeBase parent) throws IOException {
        this(root, parent, parent != null ? parent.getClassLoader() : null);
    }

    @Override
    protected Class loadLocalClass(String className) throws IOException, ClassNotFoundException {
        String resourceName = JavaCodeBase.classNameToPath(className);
        FileObject fileObject = this.root.resolveFile(resourceName + ".groovy");
        if (fileObject.exists()) {
            try {
                return this.loadGroovyFile(fileObject);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClassNotFoundException(className, e);
            }
        }
        return null;
    }

    public Class loadGroovyFile(FileObject fileObject) throws FileSystemException, ResourceException, ScriptException {
        return this.groovyScriptEngine.loadScriptByName(fileObject.getURL().toString());
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void clear() throws Exception {
        super.clear();
        this.resetGroovyScriptEngine();
    }
}

