/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.ui.support.pages;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.blobs.MultipartWrapper;
import com.manydesigns.portofino.ui.support.ApiInfo;
import com.manydesigns.portofino.ui.support.Resource;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pages")
public class Pages
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger(Pages.class);
    public static final String PORTOFINO_ACTION_MOVE_TYPE = "application/vnd.com.manydesigns.portofino.action-move";
    public static final String PORTOFINO_PAGE_MOVE_TYPE = "application/vnd.com.manydesigns.portofino.page-move";

    @POST
    @Path(value="{path:.+}")
    public Response createPageAndAction(@HeaderParam(value="Authorization") String auth, @PathParam(value="path") String path, @QueryParam(value="loginPath") String loginPath, @QueryParam(value="actionClass") String actionClass, @QueryParam(value="actionPath") String actionPath, @QueryParam(value="childrenProperty") String childrenProperty, String pageConfigurationString) {
        this.checkPathAndAuth(path, auth, loginPath);
        actionPath = this.getActionPath(actionPath);
        if (actionPath != null && actionClass != null) {
            Invocation.Builder request = this.path(actionPath).request().header("Authorization", (Object)auth);
            Response response = request.post(Entity.text((Object)actionClass));
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                this.createPage(path, childrenProperty, pageConfigurationString);
            }
            return response;
        }
        this.createPage(path, childrenProperty, pageConfigurationString);
        return Response.ok().build();
    }

    public void createPage(String path, String childrenProperty, String pageConfigurationString) {
        Map parentConfig;
        this.saveConfigJson("pages/" + path, pageConfigurationString);
        ObjectMapper mapper = new ObjectMapper();
        String configPath = this.servletContext.getRealPath("pages/" + path);
        File pageDirectory = new File(configPath).getParentFile();
        File parentDirectory = pageDirectory.getParentFile();
        File parentConfigFile = new File(parentDirectory, "config.json");
        try (FileReader fr = new FileReader(parentConfigFile);){
            Map pageConfiguration = (Map)mapper.readValue(pageConfigurationString, Map.class);
            String parentConfigString = IOUtils.toString((Reader)fr);
            parentConfig = (Map)mapper.readValue(parentConfigString, Map.class);
            List<Map> children = this.ensureChildren(parentConfig, childrenProperty);
            HashMap<String, Object> child = new HashMap<String, Object>();
            child.put("path", pageDirectory.getName());
            child.put("title", pageConfiguration.get("title"));
            child.put("showInNavigation", true);
            children.add(child);
        }
        catch (IOException e) {
            logger.error("Could not save config to " + parentDirectory.getAbsolutePath(), (Throwable)e);
            throw new WebApplicationException(e.getMessage(), (Throwable)e);
        }
        this.writeConfig(mapper, parentConfig, parentConfigFile);
    }

    @NotNull
    public List<Map> ensureChildren(Map<String, Object> config, String childrenProperty) {
        ArrayList children = (ArrayList)config.get(childrenProperty);
        if (children == null) {
            children = new ArrayList();
            config.put(childrenProperty, children);
        }
        return children;
    }

    @PUT
    @Path(value="{path:.+}")
    public Response updatePageAndConfiguration(@HeaderParam(value="Authorization") String auth, @PathParam(value="path") String path, @QueryParam(value="actionConfigurationPath") String actionConfigurationPath, @QueryParam(value="loginPath") String loginPath) {
        this.checkPathAndAuth(path, auth, loginPath);
        MultipartWrapper multipart = ElementsThreadLocals.getMultipart();
        String[] actionConfigurationParameter = multipart.getParameterValues("actionConfiguration");
        String pageConfiguration = multipart.getParameterValues("pageConfiguration")[0];
        String pageConfigurationPath = "pages/" + path;
        if (actionConfigurationParameter != null) {
            Response response = this.saveActionConfiguration(auth, actionConfigurationPath, actionConfigurationParameter[0]);
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                this.saveConfigJson(pageConfigurationPath, pageConfiguration);
            }
            return response;
        }
        this.saveConfigJson(pageConfigurationPath, pageConfiguration);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{path:.+}")
    public Response deletePageAndAction(@PathParam(value="path") String path, @HeaderParam(value="Authorization") String auth, @QueryParam(value="loginPath") String loginPath, @QueryParam(value="actionPath") String actionPath, @QueryParam(value="childrenProperty") String childrenProperty) throws IOException {
        Response response;
        this.checkPathAndAuth(path, auth, loginPath);
        actionPath = this.getActionPath(actionPath);
        if (actionPath != null) {
            Invocation.Builder request = this.path(actionPath).request().header("Authorization", (Object)auth);
            response = request.delete();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                return response;
            }
        } else {
            response = Response.ok().build();
        }
        this.deletePage(path, childrenProperty);
        return response;
    }

    protected void deletePage(String path, String childrenProperty) throws IOException {
        Map parentConfig;
        File parentConfigFile;
        ObjectMapper mapper;
        block15: {
            String configPath = this.servletContext.getRealPath("pages/" + path);
            File file = new File(configPath);
            FileUtils.deleteDirectory((File)file.getParentFile());
            mapper = new ObjectMapper();
            File pageDirectory = new File(configPath).getParentFile();
            File parentDirectory = pageDirectory.getParentFile();
            parentConfigFile = new File(parentDirectory, "config.json");
            try (FileReader fr = new FileReader(parentConfigFile);){
                String parentConfigString = IOUtils.toString((Reader)fr);
                parentConfig = (Map)mapper.readValue(parentConfigString, Map.class);
                List children = (List)parentConfig.get(childrenProperty);
                if (children == null) break block15;
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    if (!((Map)iterator.next()).get("path").equals(pageDirectory.getName())) continue;
                    iterator.remove();
                    break;
                }
            }
            catch (IOException e) {
                logger.error("Could not save config to " + parentDirectory.getAbsolutePath(), (Throwable)e);
                throw new WebApplicationException(e.getMessage(), (Throwable)e);
            }
        }
        this.writeConfig(mapper, parentConfig, parentConfigFile);
    }

    @POST
    @Path(value="{destinationPath:.+}")
    @Consumes(value={"application/vnd.com.manydesigns.portofino.page-move"})
    public Response movePageAndAction(@HeaderParam(value="Authorization") String auth, @PathParam(value="destinationPath") String destinationPath, @QueryParam(value="loginPath") String loginPath, @QueryParam(value="segment") String segment, @QueryParam(value="sourceActionPath") String sourceActionPath, @QueryParam(value="destinationActionParent") String destinationActionParent, @QueryParam(value="detail") boolean detail, String sourcePath) throws IOException {
        String actionPath;
        String destinationActionPath;
        this.checkPathAndAuth(destinationPath, auth, loginPath);
        this.checkPath(sourcePath);
        String baseUri = ApiInfo.getApiRootUri(this.servletContext, this.uriInfo);
        File destParentConfigFile = new File(this.servletContext.getRealPath("pages/" + destinationPath));
        if (destinationActionParent == null) {
            this.movePage(sourcePath, destParentConfigFile, segment, detail);
            return Response.ok().build();
        }
        if (sourceActionPath.startsWith(baseUri)) {
            sourceActionPath = sourceActionPath.substring(baseUri.length());
        }
        if ((destinationActionPath = this.getActionPath(actionPath = destinationActionParent + (detail ? "/_detail/" : "/") + segment)) == null) {
            throw new WebApplicationException("Invalid destination action path: " + actionPath);
        }
        Invocation.Builder request = this.path(destinationActionPath).request().header("Authorization", (Object)auth);
        Response response = request.post(Entity.entity((Object)sourceActionPath, (String)PORTOFINO_ACTION_MOVE_TYPE));
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            this.movePage(sourcePath, destParentConfigFile, segment, detail);
        }
        return response;
    }

    public void movePage(String sourcePath, File destParentConfigFile, String segment, boolean detail) throws IOException {
        if (segment.contains("..") || segment.contains(File.separator)) {
            throw new IllegalArgumentException("Invalid segment: " + segment);
        }
        File sourceConfigFile = new File(this.servletContext.getRealPath(sourcePath));
        File destParentConfigDir = destParentConfigFile.getParentFile();
        File destConfigDir = new File(destParentConfigDir, segment);
        if (!destConfigDir.isDirectory() && !destConfigDir.mkdirs()) {
            throw new WebApplicationException("Could not create directory " + destConfigDir.getAbsolutePath());
        }
        this.movePage(sourceConfigFile, new File(destConfigDir, "config.json"), detail ? "detailChildren" : "children");
    }

    public void movePage(File sourceConfigFile, File destConfigFile, String childrenProperty) throws IOException {
        Map parentDestConfig;
        Map originalChild;
        Map parentSourceConfig;
        FileUtils.moveFile((File)sourceConfigFile, (File)destConfigFile);
        ObjectMapper mapper = new ObjectMapper();
        File sourceDirectory = sourceConfigFile.getParentFile();
        File parentSourceConfigFile = new File(sourceDirectory.getParentFile(), "config.json");
        try (FileReader fr = new FileReader(parentSourceConfigFile);){
            String parentConfigString = IOUtils.toString((Reader)fr);
            parentSourceConfig = (Map)mapper.readValue(parentConfigString, Map.class);
            List children = (List)parentSourceConfig.get("children");
            originalChild = this.removeChild(sourceDirectory.getName(), children);
            if (originalChild == null) {
                children = (List)parentSourceConfig.get("detailChildren");
                originalChild = this.removeChild(sourceDirectory.getName(), children);
            }
        }
        catch (IOException e) {
            logger.error("Could not save config to " + parentSourceConfigFile.getAbsolutePath(), (Throwable)e);
            throw new WebApplicationException(e.getMessage(), (Throwable)e);
        }
        this.writeConfig(mapper, parentSourceConfig, parentSourceConfigFile);
        File destDirectory = destConfigFile.getParentFile();
        File parentDestConfigFile = new File(destDirectory.getParentFile(), "config.json");
        try (FileReader fr = new FileReader(parentDestConfigFile);){
            String parentConfigString = IOUtils.toString((Reader)fr);
            parentDestConfig = (Map)mapper.readValue(parentConfigString, Map.class);
            List<Map> children = this.ensureChildren(parentDestConfig, childrenProperty);
            HashMap<String, String> child = new HashMap<String, String>();
            child.putAll(originalChild);
            child.put("path", destDirectory.getName());
            children.add(child);
        }
        catch (IOException e) {
            logger.error("Could not save config to " + parentDestConfigFile.getAbsolutePath(), (Throwable)e);
            throw new WebApplicationException(e.getMessage(), (Throwable)e);
        }
        this.writeConfig(mapper, parentDestConfig, parentDestConfigFile);
    }

    public void writeConfig(ObjectMapper mapper, Map<String, Object> config, File configFile) {
        try (FileWriter fw = new FileWriter(configFile);){
            ObjectWriter objectWriter = mapper.writerFor(Map.class);
            objectWriter.withDefaultPrettyPrinter().writeValue((Writer)fw, config);
        }
        catch (IOException e) {
            logger.error("Could not save config to " + configFile.getAbsolutePath(), (Throwable)e);
            throw new WebApplicationException(e.getMessage(), (Throwable)e);
        }
    }

    public Map removeChild(String name, List<Map> children) {
        if (children != null) {
            Iterator<Map> iterator = children.iterator();
            while (iterator.hasNext()) {
                Map child = iterator.next();
                if (!name.equals(child.get("path"))) continue;
                iterator.remove();
                return child;
            }
        }
        return null;
    }

    public String getActionPath(String actionPath) {
        if (actionPath == null) {
            return null;
        }
        String baseUri = ApiInfo.getApiRootUri(this.servletContext, this.uriInfo);
        if (actionPath.startsWith(baseUri)) {
            actionPath = actionPath.substring(baseUri.length());
        } else {
            try {
                new URL(actionPath);
                return null;
            }
            catch (MalformedURLException e) {
                logger.debug(actionPath, (Throwable)e);
            }
        }
        actionPath = "portofino-upstairs/actions/" + actionPath;
        return actionPath;
    }

    public void checkPathAndAuth(String path, String auth, String loginPath) {
        this.checkPath(path);
        if (!this.checkAdmin(loginPath, auth)) {
            throw new WebApplicationException(Response.status((Response.Status)(auth != null ? Response.Status.UNAUTHORIZED : Response.Status.FORBIDDEN)).build());
        }
    }

    public void checkPath(String path) {
        if (path.contains("..") || !path.endsWith("config.json")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid config.json path").type(MediaType.TEXT_PLAIN_TYPE).build());
        }
    }

    public Response saveActionConfiguration(String auth, String actionConfigurationPath, String actionConfiguration) {
        String apiRootUri = ApiInfo.getApiRootUri(this.servletContext, this.uriInfo);
        if (actionConfigurationPath.startsWith(apiRootUri)) {
            actionConfigurationPath = actionConfigurationPath.substring(apiRootUri.length());
        }
        if (actionConfigurationPath.startsWith("http://") || actionConfigurationPath.startsWith("https://")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Non-local action configuration path").type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        Invocation.Builder req = this.path(actionConfigurationPath).request();
        req = req.header("Authorization", (Object)auth);
        return req.put(Entity.entity((Object)actionConfiguration, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void saveConfigJson(String path, String pageConfiguration) {
        String configPath = this.servletContext.getRealPath(path);
        File file = new File(configPath);
        file.getParentFile().mkdirs();
        try (FileWriter fw = new FileWriter(file);){
            new JSONObject(pageConfiguration).write((Writer)fw, 2, 0);
            logger.info("Saved page configuration to " + file.getAbsolutePath());
        }
        catch (IOException e) {
            logger.error("Could not save config to " + file.getAbsolutePath(), (Throwable)e);
            throw new WebApplicationException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean checkAdmin(String loginPath, String authorization) {
        Invocation.Builder req = this.path(loginPath).request();
        Response response = (req = req.header("Authorization", (Object)authorization)).get();
        if (response.getStatus() == 200) {
            Map info = (Map)response.readEntity(Map.class);
            return (Boolean)info.get("administrator");
        }
        return false;
    }
}

