/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.ui.support;

import com.manydesigns.portofino.ui.support.Resource;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/")
public class ApiInfo
extends Resource {
    @GET
    @Produces(value={"application/json"})
    public Map info() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("apiRoot", ApiInfo.getApiRootUri(this.servletContext, this.uriInfo));
        try {
            Invocation.Builder request = this.path(":description").request();
            Response response = request.get();
            if (response.getStatus() == 200) {
                Map map = (Map)response.readEntity(Map.class);
                info.put("loginPath", map.get("loginPath").toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    public static String getApiRootUri(ServletContext servletContext, UriInfo uriInfo) {
        return ApiInfo.getApiRootUri(servletContext, uriInfo.getBaseUri());
    }

    public static String getApiRootUri(ServletContext servletContext, URI baseUri) {
        String apiRoot = servletContext.getInitParameter("portofino.api.root");
        if (apiRoot == null) {
            apiRoot = "";
        }
        if (!apiRoot.contains("://")) {
            String baseAddress = baseUri.getScheme() + "://" + baseUri.getAuthority();
            if (!apiRoot.startsWith("/")) {
                baseAddress = baseAddress + servletContext.getContextPath();
            }
            apiRoot = baseAddress + "/" + apiRoot;
        }
        if (!apiRoot.endsWith("/")) {
            apiRoot = apiRoot + "/";
        }
        return apiRoot;
    }
}

