/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.ui.support.pages;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URLDecoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class ConfigJsonCacheFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String path = request.getRequestURI().substring(request.getContextPath().length());
        if ((path = URLDecoder.decode(path, "UTF-8")).endsWith("config.json")) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            response.addHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
            response.setHeader("Content-Type", "application/json");
            File configJsonFile = new File(request.getServletContext().getRealPath(path));
            try (FileReader reader = new FileReader(configJsonFile);){
                IOUtils.copy((Reader)reader, (Writer)response.getWriter());
            }
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void destroy() {
    }
}

