/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import com.manydesigns.elements.blobs.FileBean;
import com.manydesigns.elements.blobs.FileUploadLimitExceededException;
import com.manydesigns.elements.blobs.IteratorEnumeration;
import com.manydesigns.elements.blobs.MultipartRequest;
import com.manydesigns.elements.blobs.MultipartWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;

public class StreamingCommonsMultipartWrapper
implements MultipartWrapper {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    private static final Pattern WINDOWS_PATH_PREFIX_PATTERN = Pattern.compile("(?i:^[A-Z]:\\\\)");
    private Map<String, FileItem> files = new HashMap<String, FileItem>();
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private String charset;

    @Override
    public void build(HttpServletRequest request, File tempDir, long maxPostSize) throws IOException, FileUploadLimitExceededException {
        try {
            this.charset = request.getCharacterEncoding();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setRepository(tempDir);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(maxPostSize);
            FileItemIterator iterator = upload.getItemIterator(request);
            HashMap<String, List> params = new HashMap<String, List>();
            while (iterator.hasNext()) {
                FileItemStream item = iterator.next();
                InputStream stream = item.openStream();
                Throwable throwable = null;
                try {
                    if (item.isFormField()) {
                        List values = params.computeIfAbsent(item.getFieldName(), k -> new ArrayList());
                        values.add(this.charset == null ? IOUtils.toString((InputStream)stream) : IOUtils.toString((InputStream)stream, (String)this.charset));
                        continue;
                    }
                    File tempFile = File.createTempFile("portofino-temp-" + item.getName(), ".temp");
                    int size = StreamingCommonsMultipartWrapper.copyInputStreamToFile(stream, tempFile);
                    FileItem fileItem = new FileItem(item.getName(), item.getContentType(), tempFile, size);
                    this.files.put(item.getFieldName(), fileItem);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            for (Map.Entry entry : params.entrySet()) {
                List values = (List)entry.getValue();
                this.parameters.put((String)entry.getKey(), values.toArray(new String[0]));
            }
        }
        catch (FileUploadBase.SizeLimitExceededException slee) {
            throw new FileUploadLimitExceededException(maxPostSize, slee.getActualSize());
        }
        catch (FileUploadException fue) {
            throw new IOException("Could not parse and cache file upload data.", fue);
        }
    }

    /*
     * Exception decompiling
     */
    public static int copyInputStreamToFile(InputStream source, File destination) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return new IteratorEnumeration(this.parameters.keySet().iterator());
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Enumeration<String> getFileParameterNames() {
        return new IteratorEnumeration(this.files.keySet().iterator());
    }

    @Override
    public FileBean getFileParameterValue(String name) {
        int index;
        final FileItem item = this.files.get(name);
        if (item == null || (item.fileName == null || item.fileName.length() == 0) && item.size == 0) {
            return null;
        }
        String filename = item.fileName;
        if (filename != null && (index = WINDOWS_PATH_PREFIX_PATTERN.matcher(filename).find() ? filename.lastIndexOf(92) : filename.lastIndexOf(47)) >= 0 && index + 1 < filename.length() - 1) {
            filename = filename.substring(index + 1);
        }
        return new FileBean(null, item.contentType, filename, this.charset){

            @Override
            public long getSize() {
                return item.size;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new FileInputStream(item.contents);
            }

            @Override
            public void delete() throws IOException {
                item.contents.delete();
            }
        };
    }

    @Override
    public HttpServletRequestWrapper wrapRequest(HttpServletRequest request) {
        return new MultipartRequest(request, this);
    }

    static {
        FileUploadException.class.getName();
    }

    public static class FileItem {
        public final String fileName;
        public final String contentType;
        public final File contents;
        public final int size;

        public FileItem(String fileName, String contentType, File contents, int size) {
            this.fileName = fileName;
            this.contentType = contentType;
            this.contents = contents;
            this.size = size;
        }
    }
}

