/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.test;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.servlet.MutableHttpServletRequest;
import com.manydesigns.elements.servlet.MutableServletContext;
import com.manydesigns.elements.xml.XmlBuffer;
import java.util.Locale;
import org.apache.commons.configuration2.Configuration;

public abstract class ElementsTestSupport {
    public static final String copyright = "Copyright (c) 2005-2019, ManyDesigns srl";
    public Configuration elementsConfiguration;
    public MutableServletContext servletContext;
    public MutableHttpServletRequest req;

    public void setUp() throws Exception {
        XmlBuffer.checkWellFormed = true;
        this.setUpProperties();
        this.setUpSingletons();
        this.setUpRequest();
        this.setUpElementsThreadLocals();
    }

    public void setUpProperties() {
        this.elementsConfiguration = ElementsProperties.getConfiguration();
    }

    public void setUpSingletons() {
        this.servletContext = new MutableServletContext();
    }

    public void setUpRequest() {
        this.req = new MutableHttpServletRequest(this.servletContext);
        this.req.setContextPath("");
        this.req.setRequestURI("");
        this.req.locales.clear();
        this.req.locales.add(Locale.forLanguageTag("en"));
        this.req.locales.add(Locale.forLanguageTag("it"));
    }

    public void setUpElementsThreadLocals() {
        Locale.setDefault(Locale.ENGLISH);
        ElementsThreadLocals.setupDefaultElementsContext();
        ElementsThreadLocals.setHttpServletRequest(this.req);
        ElementsThreadLocals.setServletContext(this.servletContext);
    }

    public void tearDown() throws Exception {
        ElementsThreadLocals.removeElementsContext();
    }
}

