/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.search;

import com.manydesigns.elements.annotations.Select;
import com.manydesigns.elements.fields.search.AbstractSearchField;
import com.manydesigns.elements.fields.search.Criteria;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.options.DefaultSelectionProvider;
import com.manydesigns.elements.options.SearchDisplayMode;
import com.manydesigns.elements.options.SelectionModel;
import com.manydesigns.elements.options.SelectionProvider;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SelectSearchField
extends AbstractSearchField {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected SelectionModel selectionModel;
    protected int selectionModelIndex;
    protected boolean notSet;
    protected String comboLabel;
    protected String notSetLabel;
    protected SearchDisplayMode displayMode;
    protected String autocompleteId;
    protected String autocompleteInputName;
    protected SelectSearchField previousSelectField;
    protected SelectSearchField nextSelectField;
    public static final String AUTOCOMPLETE_SUFFIX = "_autocomplete";
    public static final String VALUE_NOT_SET = "__notset__";

    public SelectSearchField(PropertyAccessor accessor, String prefix) {
        this(accessor, null, prefix);
    }

    private void initializeModel(PropertyAccessor accessor, SelectionProvider selectionProvider) {
        Select annotation = accessor.getAnnotation(Select.class);
        if (selectionProvider == null) {
            if (annotation != null) {
                String[] values = annotation.values();
                String[] labels = annotation.labels();
                assert (values.length == labels.length);
                DefaultSelectionProvider sp = new DefaultSelectionProvider(accessor.getName(), 1);
                for (int i = 0; i < values.length; ++i) {
                    sp.appendOption(values[i], labels[i], true);
                }
                this.selectionModel = sp.createSelectionModel();
                this.displayMode = annotation.searchDisplayMode();
            }
        } else {
            this.displayMode = selectionProvider.getSearchDisplayMode();
            if (this.displayMode == null && annotation != null) {
                this.displayMode = annotation.searchDisplayMode();
            }
        }
        if (this.displayMode == null) {
            this.displayMode = SearchDisplayMode.DROPDOWN;
        }
        this.selectionModelIndex = 0;
        this.comboLabel = this.getText("elements.field.select.select", this.label);
        this.notSetLabel = this.getText("elements.search.select.notset", this.label);
        this.autocompleteId = this.id + AUTOCOMPLETE_SUFFIX;
        this.autocompleteInputName = this.inputName + AUTOCOMPLETE_SUFFIX;
    }

    public SelectSearchField(PropertyAccessor accessor, SelectionProvider selectionProvider, String prefix) {
        super(accessor, prefix);
        this.initializeModel(accessor, selectionProvider);
    }

    @Override
    public void toSearchString(StringBuilder sb, String encoding) {
        if (!this.required && this.notSet) {
            this.appendToSearchString(sb, this.inputName, VALUE_NOT_SET, encoding);
            return;
        }
        Object[] values = this.getValues();
        if (null != values) {
            for (Object value : values) {
                String valueString = OgnlUtils.convertValueToString(value);
                this.appendToSearchString(sb, this.inputName, valueString, encoding);
            }
        }
    }

    @Override
    public void configureCriteria(Criteria criteria) {
        if (!this.required && this.notSet) {
            criteria.isNull(this.accessor);
            return;
        }
        Object[] values = this.getValues();
        if (values == null) {
            logger.debug("Null values array. Not adding 'in' criteria.");
        } else if (values.length == 0) {
            logger.debug("Enpty values array. Not adding 'in' criteria.");
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding 'in' criteria for values: {}", (Object)ArrayUtils.toString((Object)values));
            }
            criteria.in(this.accessor, values);
        }
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        String[] values = req.getParameterValues(this.inputName);
        if (values == null) {
            return;
        }
        if (values.length == 1 && VALUE_NOT_SET.equals(values[0])) {
            this.notSet = true;
        } else if (SearchDisplayMode.AUTOCOMPLETE == this.displayMode) {
            Object value;
            boolean search;
            String stringValue = values[0].toString();
            String userValue = req.getParameter(this.autocompleteInputName);
            if (StringUtils.isEmpty((String)stringValue)) {
                search = true;
                value = null;
            } else {
                value = OgnlUtils.convertValue(stringValue, this.accessor.getType());
                String label = this.selectionModel.getOption(this.selectionModelIndex, value, true);
                boolean bl = search = userValue != null && !StringUtils.equals((String)userValue, (String)label);
            }
            if (search) {
                value = null;
                Map<Object, SelectionModel.Option> options = this.selectionModel.getOptions(this.selectionModelIndex);
                boolean found = false;
                for (SelectionModel.Option option : options.values()) {
                    if (!ObjectUtils.equals((Object)userValue, (Object)option.label)) continue;
                    found = true;
                    value = option.value;
                }
                if (!found) {
                    return;
                }
            }
            this.selectionModel.setValue(this.selectionModelIndex, value);
        } else {
            Object[] castedValues = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (StringUtils.isEmpty((String)values[i])) continue;
                castedValues[i] = OgnlUtils.convertValueQuietly(values[i], this.accessor.getType());
            }
            this.selectionModel.setValue(this.selectionModelIndex, castedValues);
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        xb.openElement("div");
        xb.addAttribute("class", "form-group");
        switch (this.displayMode) {
            case DROPDOWN: {
                this.valueToXhtmlDropDown(xb);
                break;
            }
            case RADIO: {
                this.valueToXhtmlRadio(xb);
                break;
            }
            case AUTOCOMPLETE: {
                this.valueToXhtmlAutocomplete(xb);
                break;
            }
            case CHECKBOX: {
                this.valueToXhtmlCheckbox(xb);
                break;
            }
            case MULTIPLESELECT: {
                this.valueToXhtmlMultipleSelection(xb);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown display mode: " + this.displayMode.name());
            }
        }
        xb.closeElement("div");
    }

    private void valueToXhtmlDropDown(XhtmlBuffer xb) {
        boolean selected;
        xb.writeLabel(StringUtils.capitalize((String)this.label), this.id, "control-label");
        Object[] values = this.getValues();
        Map<Object, SelectionModel.Option> options = this.selectionModel.getOptions(this.selectionModelIndex);
        xb.openElement("select");
        xb.addAttribute("id", this.id);
        xb.addAttribute("name", this.inputName);
        xb.addAttribute("class", "form-control");
        boolean bl = selected = values == null && !this.notSet;
        if (!options.isEmpty()) {
            xb.writeOption("", selected, this.comboLabel);
            if (!this.required) {
                xb.writeOption(VALUE_NOT_SET, this.notSet, this.notSetLabel);
            }
        }
        for (Map.Entry<Object, SelectionModel.Option> option : options.entrySet()) {
            Object optionValue = option.getKey();
            String optionStringValue = OgnlUtils.convertValueToString(optionValue);
            String optionLabel = option.getValue().label;
            selected = ArrayUtils.contains((Object[])values, (Object)optionValue);
            xb.writeOption(optionStringValue, selected, optionLabel);
        }
        xb.closeElement("select");
        if (this.nextSelectField != null) {
            String js = this.composeDropDownJs();
            xb.writeJavaScript(js);
        }
    }

    public String composeDropDownJs() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("$(''#{0}'').change(function() '{'updateSelectOptions(''{1}'', {2}, ''jsonSelectFieldSearchOptions''", StringEscapeUtils.escapeJavaScript((String)this.id), StringEscapeUtils.escapeJavaScript((String)this.selectionModel.getName()), this.selectionModelIndex + 1));
        this.appendIds(sb);
        sb.append(");});");
        return sb.toString();
    }

    public void valueToXhtmlRadio(XhtmlBuffer xb) {
        Object[] values = this.getValues();
        Map<Object, SelectionModel.Option> options = this.selectionModel.getOptions(this.selectionModelIndex);
        xb.writeLabel(StringUtils.capitalize((String)this.label), this.id, "control-label");
        xb.openElement("div");
        xb.addAttribute("class", "form-control radio");
        int counter = 0;
        if (!this.required) {
            String radioId = this.id + "_" + counter;
            boolean checked = values == null && !this.notSet;
            this.writeRadioWithLabel(xb, radioId, this.getText("elements.search.select.none", new Object[0]), "", checked);
            radioId = this.id + "_" + ++counter;
            this.writeRadioWithLabel(xb, radioId, this.getText("elements.search.select.notset.radio", new Object[0]), VALUE_NOT_SET, this.notSet);
            ++counter;
        }
        for (Map.Entry<Object, SelectionModel.Option> option : options.entrySet()) {
            if (!option.getValue().active) continue;
            Object optionValue = option.getKey();
            String optionStringValue = OgnlUtils.convertValueToString(optionValue);
            String optionLabel = option.getValue().label;
            String radioId = this.id + "_" + counter;
            boolean checked = ArrayUtils.contains((Object[])values, (Object)optionValue);
            this.writeRadioWithLabel(xb, radioId, optionLabel, optionStringValue, checked);
            ++counter;
        }
        xb.closeElement("div");
    }

    protected void writeRadioWithLabel(XhtmlBuffer xb, String radioId, String label, String stringValue, boolean checked) {
        xb.writeInputRadio(radioId, this.inputName, stringValue, checked);
        xb.openElement("label");
        xb.addAttribute("class", "radio");
        xb.addAttribute("for", radioId);
        xb.write(label);
        xb.closeElement("label");
    }

    public void valueToXhtmlAutocomplete(XhtmlBuffer xb) {
        xb.writeLabel(StringUtils.capitalize((String)this.label), this.id, "control-label");
        Object value = this.selectionModel.getValue(this.selectionModelIndex);
        String stringValue = OgnlUtils.convertValueToString(value);
        xb.writeInputHidden(this.id, this.inputName, stringValue);
        String label = this.selectionModel.getOption(this.selectionModelIndex, value, true);
        xb.openElement("input");
        xb.addAttribute("id", this.autocompleteId);
        xb.addAttribute("type", "text");
        xb.addAttribute("name", this.autocompleteInputName);
        xb.addAttribute("value", label);
        xb.addAttribute("class", "form-control");
        xb.addAttribute("size", null);
        xb.closeElement("input");
        String js = this.composeAutocompleteJs();
        xb.writeJavaScript(js);
    }

    private void valueToXhtmlCheckbox(XhtmlBuffer xb) {
        xb.writeLabel(StringUtils.capitalize((String)this.label), this.id, "control-label");
        Object[] values = this.getValues();
        Map<Object, SelectionModel.Option> options = this.selectionModel.getOptions(this.selectionModelIndex);
        int counter = 0;
        for (Map.Entry<Object, SelectionModel.Option> option : options.entrySet()) {
            if (!option.getValue().active) continue;
            xb.openElement("div");
            xb.addAttribute("class", "form-control checkbox");
            Object optionValue = option.getKey();
            String optionStringValue = OgnlUtils.convertValueToString(optionValue);
            String optionLabel = option.getValue().label;
            boolean checked = ArrayUtils.contains((Object[])values, (Object)optionValue);
            String checkboxId = this.id + "_" + counter;
            xb.writeInputCheckbox(checkboxId, this.inputName, optionStringValue, checked);
            xb.openElement("label");
            xb.addAttribute("for", checkboxId);
            xb.write(optionLabel);
            xb.closeElement("label");
            xb.closeElement("div");
            ++counter;
        }
    }

    private void valueToXhtmlMultipleSelection(XhtmlBuffer xb) {
        xb.writeLabel(StringUtils.capitalize((String)this.label), this.id, "control-label");
        xb.openElement("div");
        xb.addAttribute("class", "form-control multiple-select");
        Object[] values = this.getValues();
        Map<Object, SelectionModel.Option> options = this.selectionModel.getOptions(this.selectionModelIndex);
        xb.openElement("select");
        xb.addAttribute("id", this.id);
        xb.addAttribute("name", this.inputName);
        xb.addAttribute("multiple", "multiple");
        xb.addAttribute("size", "5");
        for (Map.Entry<Object, SelectionModel.Option> option : options.entrySet()) {
            if (!option.getValue().active) continue;
            Object optionValue = option.getKey();
            String optionStringValue = OgnlUtils.convertValueToString(optionValue);
            String optionLabel = option.getValue().label;
            boolean checked = ArrayUtils.contains((Object[])values, (Object)optionValue);
            xb.writeOption(optionStringValue, checked, optionLabel);
        }
        xb.closeElement("select");
        xb.closeElement("div");
    }

    public String composeAutocompleteJs() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("setupAutocomplete(''#{0}'', ''{1}'', {2}, ''jsonAutocompleteSearchOptions''", StringEscapeUtils.escapeJavaScript((String)this.autocompleteId), StringEscapeUtils.escapeJavaScript((String)this.selectionModel.getName()), this.selectionModelIndex));
        this.appendIds(sb);
        sb.append(");");
        return sb.toString();
    }

    public void appendIds(StringBuilder sb) {
        SelectSearchField rootField = this;
        while (rootField.previousSelectField != null) {
            rootField = rootField.previousSelectField;
        }
        SelectSearchField currentField = rootField;
        while (currentField != null) {
            sb.append(MessageFormat.format(", ''#{0}''", StringEscapeUtils.escapeJavaScript((String)currentField.getId())));
            currentField = currentField.nextSelectField;
        }
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public int getSelectionModelIndex() {
        return this.selectionModelIndex;
    }

    public void setSelectionModelIndex(int selectionModelIndex) {
        this.selectionModelIndex = selectionModelIndex;
    }

    public String getComboLabel() {
        return this.comboLabel;
    }

    public void setComboLabel(String comboLabel) {
        this.comboLabel = comboLabel;
    }

    public String getNotSetLabel() {
        return this.notSetLabel;
    }

    public void setNotSetLabel(String notSetLabel) {
        this.notSetLabel = notSetLabel;
    }

    public SearchDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(SearchDisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public String getAutocompleteId() {
        return this.autocompleteId;
    }

    public void setAutocompleteId(String autocompleteId) {
        this.autocompleteId = autocompleteId;
    }

    public String getAutocompleteInputName() {
        return this.autocompleteInputName;
    }

    public void setAutocompleteInputName(String autocompleteInputName) {
        this.autocompleteInputName = autocompleteInputName;
    }

    public SelectSearchField getPreviousSelectField() {
        return this.previousSelectField;
    }

    public void setPreviousSelectField(SelectSearchField previousSelectField) {
        this.previousSelectField = previousSelectField;
    }

    public SelectSearchField getNextSelectField() {
        return this.nextSelectField;
    }

    public void setNextSelectField(SelectSearchField nextSelectField) {
        this.nextSelectField = nextSelectField;
    }

    public Object[] getValues() {
        Object object = this.selectionModel.getValue(this.selectionModelIndex);
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object != null) {
            return new Object[]{object};
        }
        return null;
    }

    public void setValue(Object[] values) {
        this.selectionModel.setValue(this.selectionModelIndex, values);
    }

    public Map<Object, SelectionModel.Option> getOptions() {
        return this.selectionModel.getOptions(this.selectionModelIndex);
    }

    public String getLabelSearch() {
        return this.selectionModel.getLabelSearch(this.selectionModelIndex);
    }
}

