/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection;

import com.manydesigns.elements.reflection.AbstractAnnotatedAccessor;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;

public class FilteredClassAccessor
extends AbstractAnnotatedAccessor
implements ClassAccessor {
    protected final ClassAccessor delegate;
    protected final PropertyAccessor[] properties;
    protected final PropertyAccessor[] keyProperties;

    protected FilteredClassAccessor(ClassAccessor delegate, boolean whitelist, String ... properties) {
        this.delegate = delegate;
        ArrayList<PropertyAccessor> propertiesList = new ArrayList<PropertyAccessor>();
        ArrayList<PropertyAccessor> keyPropertiesList = new ArrayList<PropertyAccessor>();
        for (PropertyAccessor p : delegate.getProperties()) {
            if (whitelist != ArrayUtils.contains((Object[])properties, (Object)p.getName())) continue;
            propertiesList.add(p);
            if (!ArrayUtils.contains((Object[])delegate.getKeyProperties(), (Object)p)) continue;
            keyPropertiesList.add(p);
        }
        if (whitelist && propertiesList.size() != properties.length) {
            for (String property : properties) {
                try {
                    delegate.getProperty(property);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.properties = propertiesList.toArray(new PropertyAccessor[propertiesList.size()]);
        this.keyProperties = keyPropertiesList.toArray(new PropertyAccessor[keyPropertiesList.size()]);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public Class<?> getType() {
        return this.delegate.getType();
    }

    @Override
    public PropertyAccessor getProperty(String propertyName) throws NoSuchFieldException {
        for (PropertyAccessor current : this.properties) {
            if (!current.getName().equals(propertyName)) continue;
            return current;
        }
        throw new NoSuchFieldException(propertyName);
    }

    @Override
    public PropertyAccessor[] getProperties() {
        return this.properties;
    }

    @Override
    public PropertyAccessor[] getKeyProperties() {
        return this.keyProperties;
    }

    @Override
    public Object newInstance() {
        return this.delegate.newInstance();
    }

    public static FilteredClassAccessor exclude(ClassAccessor classAccessor, String ... properties) {
        return new FilteredClassAccessor(classAccessor, false, properties);
    }

    public static FilteredClassAccessor include(ClassAccessor classAccessor, String ... properties) {
        return new FilteredClassAccessor(classAccessor, true, properties);
    }
}

