/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.HighlightLinks;
import com.manydesigns.elements.annotations.Multiline;
import com.manydesigns.elements.annotations.RichText;
import com.manydesigns.elements.annotations.Status;
import com.manydesigns.elements.fields.AbstractTextField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.Util;
import com.manydesigns.elements.xml.XhtmlBuffer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class TextField
extends AbstractTextField<String> {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    protected boolean highlightLinks = false;
    protected boolean multiline = false;
    protected boolean richText = false;
    protected Integer textAreaWidth;
    protected int textAreaMinRows = 4;
    protected String[] red;
    protected String[] amber;
    protected String[] green;
    protected String noValueText = "-";

    public TextField(PropertyAccessor accessor, Mode mode) {
        this(accessor, mode, null);
    }

    public TextField(PropertyAccessor accessor, Mode mode, String prefix) {
        super(accessor, mode, prefix);
        RichText richTextAnnotation;
        Multiline multilineAnnotation;
        HighlightLinks highlightLinksAnnotation = accessor.getAnnotation(HighlightLinks.class);
        if (highlightLinksAnnotation != null) {
            this.highlightLinks = highlightLinksAnnotation.value();
            logger.debug("HighlightLinks annotation present with value: {}", (Object)this.highlightLinks);
        }
        if ((multilineAnnotation = accessor.getAnnotation(Multiline.class)) != null) {
            this.multiline = multilineAnnotation.value();
            logger.debug("Multiline annotation present with value: {}", (Object)this.multiline);
        }
        if ((richTextAnnotation = accessor.getAnnotation(RichText.class)) != null) {
            this.multiline = richTextAnnotation.value();
            this.richText = richTextAnnotation.value();
            logger.debug("RichText annotation present with value: {}", (Object)this.richText);
        }
        if (accessor.isAnnotationPresent(Status.class)) {
            Status annotation = accessor.getAnnotation(Status.class);
            this.red = annotation.red();
            this.amber = annotation.amber();
            this.green = annotation.green();
        }
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        super.readFromRequest(req);
        if (this.mode.isView(this.insertable, this.updatable)) {
            return;
        }
        String reqValue = req.getParameter(this.inputName);
        if (reqValue == null) {
            return;
        }
        this.stringValue = reqValue.trim();
        if (this.replaceBadUnicodeCharacters) {
            this.stringValue = Util.replaceBadUnicodeCharacters(this.stringValue);
        }
        if (this.autoCapitalize) {
            this.stringValue = this.stringValue.toUpperCase();
        }
    }

    @Override
    public void readFromObject(Object obj) {
        super.readFromObject(obj);
        this.stringValue = obj == null ? null : (String)this.accessor.get(obj);
    }

    @Override
    public void writeToObject(Object obj) {
        this.writeToObject(obj, this.stringValue);
    }

    @Override
    protected void valueToXhtmlEdit(XhtmlBuffer xb) {
        if (this.multiline) {
            xb.openElement("textarea");
            xb.addAttribute("id", this.id);
            xb.addAttribute("name", this.inputName);
            String htmlClass = "form-control";
            if (this.textAreaWidth != null) {
                xb.addAttribute("cols", Integer.toString(this.textAreaWidth));
                xb.addAttribute("rows", Integer.toString(this.numRowTextArea(this.stringValue, this.textAreaWidth)));
                htmlClass = htmlClass + " mde-text-field-with-explicit-size";
            } else {
                xb.addAttribute("rows", Integer.toOctalString(this.textAreaMinRows));
            }
            if (this.richText) {
                htmlClass = htmlClass + " mde-form-rich-text";
            }
            if (this.maxLength != null) {
                xb.addAttribute("data-max-length", Integer.toString(this.maxLength));
            }
            if (!StringUtils.isEmpty((String)htmlClass)) {
                xb.addAttribute("class", htmlClass);
            }
            xb.write(this.stringValue);
            xb.closeElement("textarea");
        } else {
            super.valueToXhtmlEdit(xb);
        }
    }

    @Override
    protected void valueToXhtmlPreview(XhtmlBuffer xb) {
        this.valueToXhtmlView(xb);
        xb.writeInputHidden(this.inputName, this.stringValue);
    }

    @Override
    protected void valueToXhtmlView(XhtmlBuffer xb) {
        xb.openElement("div");
        String cssClass = "form-control-static";
        if (ArrayUtils.contains((Object[])this.red, (Object)this.stringValue)) {
            cssClass = cssClass + " status_red";
        } else if (ArrayUtils.contains((Object[])this.amber, (Object)this.stringValue)) {
            cssClass = cssClass + " status_amber";
        } else if (ArrayUtils.contains((Object[])this.green, (Object)this.stringValue)) {
            cssClass = cssClass + " status_green";
        }
        xb.addAttribute("class", cssClass);
        xb.addAttribute("id", this.id);
        if (this.href != null) {
            xb.openElement("a");
            xb.addAttribute("href", this.href);
            xb.addAttribute("alt", this.title);
        }
        if (this.richText) {
            xb.writeNoHtmlEscape(this.stringValue);
        } else {
            Util.writeFormattedText(xb, this.stringValue, this.href == null && this.highlightLinks);
        }
        if (this.href != null) {
            xb.closeElement("a");
        }
        xb.closeElement("div");
    }

    @Override
    public String getValue() {
        return this.stringValue;
    }

    @Override
    public void setValue(String value) {
        this.stringValue = value;
    }

    private int numRowTextArea(String stringValue, int cols) {
        if (stringValue == null) {
            return this.textAreaMinRows;
        }
        String[] dim = stringValue.split("\n");
        int rows = 0;
        for (String aDim : dim) {
            if (aDim.length() < cols) continue;
            rows += aDim.length() / cols;
        }
        if ((rows += dim.length) < this.textAreaMinRows) {
            rows = this.textAreaMinRows;
        }
        return rows;
    }

    public boolean isHighlightLinks() {
        return this.highlightLinks;
    }

    public void setHighlightLinks(boolean highlightLinks) {
        this.highlightLinks = highlightLinks;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isRichText() {
        return this.richText;
    }

    public void setRichText(boolean richText) {
        this.richText = richText;
    }

    public Integer getTextAreaWidth() {
        return this.textAreaWidth;
    }

    public void setTextAreaWidth(Integer textAreaWidth) {
        this.textAreaWidth = textAreaWidth;
    }

    public int getTextAreaMinRows() {
        return this.textAreaMinRows;
    }

    public void setTextAreaMinRows(int textAreaMinRows) {
        this.textAreaMinRows = textAreaMinRows;
    }

    public String getNoValueText() {
        return this.noValueText;
    }

    public void setNoValueText(String noValueText) {
        this.noValueText = noValueText;
    }
}

