/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.servlet;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.blobs.FileUploadLimitExceededException;
import com.manydesigns.elements.blobs.MultipartWrapper;
import com.manydesigns.elements.blobs.StreamingCommonsMultipartWrapper;
import com.manydesigns.elements.servlet.AttributeMap;
import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ognl.OgnlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementsFilter
implements Filter {
    public static final String copyright = "Copyright (C) 2005-2019 ManyDesigns srl";
    public static final String REQUEST_OGNL_ATTRIBUTE = "request";
    public static final String SESSION_OGNL_ATTRIBUTE = "session";
    public static final String SERVLET_CONTEXT_OGNL_ATTRIBUTE = "servletContext";
    protected FilterConfig filterConfig;
    protected ServletContext servletContext;
    public static final Logger logger = LoggerFactory.getLogger(ElementsFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.servletContext = filterConfig.getServletContext();
        logger.info("ElementsFilter initialized");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            this.doHttpFilter((HttpServletRequest)req, (HttpServletResponse)res, filterChain);
        } else {
            filterChain.doFilter(req, res);
        }
    }

    public void destroy() {
        ElementsThreadLocals.destroy();
        logger.info("ElementsFilter destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHttpFilter(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        ServletContext context = this.filterConfig.getServletContext();
        try {
            logger.debug("Setting up default OGNL context");
            ElementsThreadLocals.setupDefaultElementsContext();
            OgnlContext ognlContext = ElementsThreadLocals.getOgnlContext();
            logger.debug("Creating request attribute mapper");
            AttributeMap requestAttributeMap = AttributeMap.createAttributeMap((ServletRequest)req);
            ognlContext.put((Object)REQUEST_OGNL_ATTRIBUTE, (Object)requestAttributeMap);
            logger.debug("Creating session attribute mapper");
            HttpSession session = req.getSession(false);
            AttributeMap sessionAttributeMap = AttributeMap.createAttributeMap(session);
            ognlContext.put((Object)SESSION_OGNL_ATTRIBUTE, (Object)sessionAttributeMap);
            logger.debug("Creating servlet context attribute mapper");
            AttributeMap servletContextAttributeMap = AttributeMap.createAttributeMap(this.servletContext);
            ognlContext.put((Object)SERVLET_CONTEXT_OGNL_ATTRIBUTE, (Object)servletContextAttributeMap);
            String contentType = req.getContentType();
            if (contentType != null && contentType.startsWith("multipart/form-data")) {
                try {
                    MultipartWrapper multipartWrapper = this.buildMultipart(req);
                    ElementsThreadLocals.setMultipart(multipartWrapper);
                    req = multipartWrapper.wrapRequest(req);
                }
                catch (FileUploadLimitExceededException e) {
                    logger.warn("File upload limit exceeded", (Throwable)((Object)e));
                }
            }
            ElementsThreadLocals.setHttpServletRequest(req);
            ElementsThreadLocals.setHttpServletResponse(res);
            ElementsThreadLocals.setServletContext(context);
            filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        finally {
            ElementsThreadLocals.removeElementsContext();
        }
    }

    protected MultipartWrapper buildMultipart(HttpServletRequest request) throws IOException, FileUploadLimitExceededException {
        StreamingCommonsMultipartWrapper multipart = new StreamingCommonsMultipartWrapper();
        File tempDir = (File)this.servletContext.getAttribute("javax.servlet.context.tempdir");
        if (tempDir == null) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir != null) {
                tempDir = new File(tmpDir).getAbsoluteFile();
            } else {
                logger.warn("The tmpdir system property was null! File uploads will probably fail.");
            }
        }
        long maxPostSize = Long.MAX_VALUE;
        multipart.build(request, tempDir, maxPostSize);
        return multipart;
    }
}

