/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.FormElement;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.BlobManager;
import com.manydesigns.elements.fields.FileBlobField;
import com.manydesigns.elements.forms.FieldSet;
import com.manydesigns.elements.forms.Form;
import com.manydesigns.elements.forms.TableForm;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobUtils {
    private static final Logger logger = LoggerFactory.getLogger(BlobUtils.class);

    public static void loadBlobs(Form form, BlobManager blobManager, boolean loadContents) {
        for (FieldSet fieldSet : form) {
            BlobUtils.loadBlobs(fieldSet, blobManager, loadContents);
        }
    }

    public static void loadBlobs(FieldSet fieldSet, BlobManager blobManager, boolean loadContents) {
        for (FormElement field : fieldSet) {
            BlobUtils.loadBlob(field, blobManager, loadContents);
        }
    }

    public static void loadBlobs(TableForm form, BlobManager blobManager, boolean loadContents) {
        for (TableForm.Row row : form.getRows()) {
            BlobUtils.loadBlobs(row, blobManager, loadContents);
        }
    }

    public static void loadBlobs(TableForm.Row row, BlobManager blobManager, boolean loadContents) {
        for (FormElement field : row) {
            BlobUtils.loadBlob(field, blobManager, loadContents);
        }
    }

    public static void loadBlob(FormElement field, BlobManager blobManager, boolean loadContents) {
        FileBlobField fbf;
        Blob blob;
        if (FileBlobField.class.isInstance(field) && (blob = (fbf = (FileBlobField)FileBlobField.class.cast(field)).getValue()) != null) {
            try {
                if (!blob.isPropertiesLoaded()) {
                    blobManager.loadMetadata(blob);
                }
                if (loadContents) {
                    blobManager.openStream(blob);
                }
                fbf.setBlobError(null);
            }
            catch (Exception e) {
                logger.debug("Could not load blob with code " + blob.getCode() + " from BlobManager " + blobManager, (Throwable)e);
                fbf.setBlobError(ElementsThreadLocals.getText("elements.error.field.fileblob.cannotLoad", new Object[0]));
            }
        }
    }

    public static void saveBlobs(Form form, BlobManager blobManager) throws IOException {
        for (FieldSet fieldSet : form) {
            BlobUtils.saveBlobs(fieldSet, blobManager);
        }
    }

    public static void saveBlobs(FieldSet fieldSet, BlobManager blobManager) throws IOException {
        for (FormElement field : fieldSet) {
            FileBlobField fbf;
            Blob blob;
            if (!FileBlobField.class.isInstance(field) || (blob = (fbf = (FileBlobField)FileBlobField.class.cast(field)).getValue()) == null || blob.getInputStream() == null) continue;
            blobManager.save(blob);
        }
    }
}

