/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.xls;

import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.forms.FieldSet;
import com.manydesigns.elements.forms.Form;
import com.manydesigns.elements.xls.XlsUtil;
import java.io.IOException;
import java.io.OutputStream;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class FormXlsExporter {
    public static final String copyright = "Copyright (C) 2005-2017 ManyDesigns srl";
    private final Form form;
    private boolean useTemporaryFileDuringWrite = false;
    private String title = " ";

    public FormXlsExporter(Form form) {
        this.form = form;
    }

    public void export(OutputStream outputStream) throws IOException, WriteException {
        WorkbookSettings workbookSettings = new WorkbookSettings();
        workbookSettings.setUseTemporaryFileDuringWrite(this.useTemporaryFileDuringWrite);
        WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)outputStream, (WorkbookSettings)workbookSettings);
        WritableSheet sheet = workbook.createSheet(this.title, workbook.getNumberOfSheets());
        this.addHeaderToSheet(sheet);
        XlsUtil xlsUtil = new XlsUtil();
        int i = 1;
        for (FieldSet fieldset : this.form) {
            int j = 0;
            for (Field field : fieldset.fields()) {
                xlsUtil.addFieldToCell(sheet, i, j, field);
                ++j;
            }
            ++i;
        }
        workbook.write();
        workbook.close();
        outputStream.flush();
    }

    private WritableCellFormat headerExcel() {
        WritableFont fontCell = new WritableFont(WritableFont.ARIAL, 12, WritableFont.BOLD, true);
        return new WritableCellFormat(fontCell);
    }

    private void addHeaderToSheet(WritableSheet sheet) throws WriteException {
        WritableCellFormat formatCell = this.headerExcel();
        int i = 0;
        for (FieldSet fieldset : this.form) {
            for (Field field : fieldset.fields()) {
                sheet.addCell((WritableCell)new Label(i, 0, field.getLabel(), (CellFormat)formatCell));
                ++i;
            }
        }
    }

    public Form getForm() {
        return this.form;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isUseTemporaryFileDuringWrite() {
        return this.useTemporaryFileDuringWrite;
    }

    public void setUseTemporaryFileDuringWrite(boolean useTemporaryFileDuringWrite) {
        this.useTemporaryFileDuringWrite = useTemporaryFileDuringWrite;
    }
}

