/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.Repository;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRepository
implements Repository {
    public static final String copyright = "Copyright (C) 2005-2018 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(CacheRepository.class);
    private static final int MAX_SIZE = 20;
    private static final int EXPIRE_AFTER = 10;
    private static final String ID = "cache";
    private Cache<String, byte[]> cache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    @Override
    public String save(Blob blob) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)blob.getInputStream(), (OutputStream)outputStream);
        logger.debug("Storing " + blob.getFilename() + " into cache");
        this.cache.put((Object)blob.getCode(), (Object)outputStream.toByteArray());
        return blob.getCode();
    }

    @Override
    public InputStream load(Blob blob) {
        logger.debug("Retrieving " + blob.getFilename() + " from cache");
        byte[] ba = (byte[])this.cache.getIfPresent((Object)blob.getCode());
        if (ba != null) {
            blob.setInputStream(new ByteArrayInputStream(ba));
        } else {
            logger.warn("Cannot fetch " + blob.getFilename() + " from cache");
        }
        return blob.getInputStream();
    }

    @Override
    public Boolean delete(Blob blob) {
        return true;
    }

    @Override
    public String getId() {
        return ID;
    }
}

