/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.xls;

import com.manydesigns.elements.fields.DateField;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.fields.NumericField;
import com.manydesigns.elements.fields.PasswordField;
import java.math.BigDecimal;
import java.util.Date;
import jxl.CellView;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WriteException;

public class XlsUtil {
    public static final String copyright = "Copyright (C) 2005-2017 ManyDesigns srl";

    public static void addFieldToCell(WritableSheet sheet, int i, int j, Field field) throws WriteException {
        if (field instanceof NumericField) {
            NumericField numField = (NumericField)field;
            if (numField.getValue() != null) {
                Number number;
                BigDecimal decimalValue = numField.getValue();
                if (numField.getDecimalFormat() == null) {
                    number = new Number(j, i, (decimalValue == null ? null : Double.valueOf(decimalValue.doubleValue())).doubleValue());
                } else {
                    NumberFormat numberFormat = new NumberFormat(numField.getDecimalFormat().toPattern());
                    WritableCellFormat writeCellNumberFormat = new WritableCellFormat((DisplayFormat)numberFormat);
                    number = new Number(j, i, (decimalValue == null ? null : Double.valueOf(decimalValue.doubleValue())).doubleValue(), (CellFormat)writeCellNumberFormat);
                }
                sheet.addCell((WritableCell)number);
            }
        } else if (field instanceof PasswordField) {
            Label label = new Label(j, i, "********");
            sheet.addCell((WritableCell)label);
        } else if (field instanceof DateField) {
            DateField dateField = (DateField)field;
            Date date = (Date)dateField.getValue();
            if (date != null) {
                DateFormat dateFormat = new DateFormat(dateField.getDatePattern());
                WritableCellFormat wDateFormat = new WritableCellFormat((DisplayFormat)dateFormat);
                DateTime dateCell = new DateTime(j, i, dateField.getValue() == null ? null : (Date)dateField.getValue(), (CellFormat)wDateFormat);
                sheet.addCell((WritableCell)dateCell);
            }
        } else {
            Label label = new Label(j, i, field.getStringValue());
            sheet.addCell((WritableCell)label);
        }
    }

    public static void autoSizeColumns(WritableSheet sheet, int columns) {
        for (int c = 0; c < columns; ++c) {
            CellView cell = sheet.getColumnView(c);
            cell.setAutosize(true);
            sheet.setColumnView(c, cell);
        }
    }
}

