/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.util;

import java.text.MessageFormat;

public class MemoryUtil {
    public static final String copyright = "Copyright (C) 2005-2016, ManyDesigns srl";
    public static final double LOG2 = Math.log(2.0);
    public static final String[] suffixes = new String[]{" bytes", "K", "M", "G", "T", "P"};

    public static String bytesToHumanString(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Negative argument: " + bytes);
        }
        if (bytes == 1L) {
            return "1 byte";
        }
        if (bytes == 0L) {
            return MessageFormat.format("0{1}", bytes, suffixes[0]);
        }
        int log = (int)Math.log10(bytes);
        int pos = log / 3;
        double scaled = (double)bytes / Math.pow(10.0, pos * 3);
        long rounded = Math.round(scaled);
        double rounded2 = (double)Math.round(scaled * 10.0) / 10.0;
        if (pos == 0) {
            return MessageFormat.format("{0,number,0}{1}", rounded, suffixes[pos]);
        }
        if (rounded >= 1000L) {
            rounded2 = (double)Math.round((scaled /= 1000.0) * 10.0) / 10.0;
            return MessageFormat.format("{0,number,0.0}{1}", rounded2, suffixes[++pos]);
        }
        if (rounded2 < 10.0) {
            return MessageFormat.format("{0,number,0.0}{1}", rounded2, suffixes[pos]);
        }
        return MessageFormat.format("{0,number,0}{1}", rounded, suffixes[pos]);
    }
}

