/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.i18n;

import com.manydesigns.elements.i18n.TextProvider;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTextProvider
implements TextProvider {
    public static final String DEFAULT_MESSAGE_RESOURCE = "com.manydesigns.elements.messages";
    private static final Logger logger = LoggerFactory.getLogger(SimpleTextProvider.class);
    protected final Locale locale;
    protected final String messageResource;
    protected final ResourceBundle resourceBundle;

    public static SimpleTextProvider create() {
        return SimpleTextProvider.create(Locale.getDefault(), DEFAULT_MESSAGE_RESOURCE);
    }

    public static SimpleTextProvider create(Locale locale) {
        return SimpleTextProvider.create(locale, DEFAULT_MESSAGE_RESOURCE);
    }

    public static SimpleTextProvider create(String messageResource) {
        return SimpleTextProvider.create(Locale.getDefault(), messageResource);
    }

    public static SimpleTextProvider create(Locale locale, String messageResource) {
        return new SimpleTextProvider(locale, messageResource);
    }

    private SimpleTextProvider(Locale locale, String messageResource) {
        ResourceBundle tmpBundle;
        this.locale = locale;
        this.messageResource = messageResource;
        try {
            tmpBundle = locale == null ? ResourceBundle.getBundle(messageResource) : ResourceBundle.getBundle(messageResource, locale);
        }
        catch (Throwable e) {
            tmpBundle = null;
        }
        this.resourceBundle = tmpBundle;
    }

    @Override
    public String getText(String key, Object ... args) {
        String localizedString = this.getLocalizedString(key);
        return MessageFormat.format(localizedString != null ? localizedString : key, args);
    }

    @Override
    public String getTextOrNull(String key, Object ... args) {
        String localizedString = this.getLocalizedString(key);
        return localizedString != null ? MessageFormat.format(localizedString, args) : null;
    }

    public String getLocalizedString(String key) {
        try {
            if (this.resourceBundle == null) {
                return null;
            }
            return this.resourceBundle.getString(key);
        }
        catch (Throwable e) {
            logger.debug("Key not found: " + key, e);
            return null;
        }
    }
}

