/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.json;

import com.manydesigns.elements.ognl.OgnlUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonBuffer {
    public static final String copyright = "Copyright (C) 2005-2025 ManyDesigns srl";
    public static boolean checkWellFormed = false;
    public Logger logger = LoggerFactory.getLogger(JsonBuffer.class);
    protected final Writer writer;
    protected boolean first;

    public JsonBuffer() {
        this(new StringWriter());
    }

    public JsonBuffer(Writer writer) {
        this.writer = writer;
        this.first = true;
    }

    public void openArray() {
        try {
            this.writeCommaIfNeeded();
            this.writer.write("[");
        }
        catch (IOException e) {
            this.logger.error("Json writer exception", (Throwable)e);
        }
        this.first = true;
    }

    public void closeArray() {
        try {
            this.writer.write("]");
        }
        catch (IOException e) {
            this.logger.error("Json writer exception", (Throwable)e);
        }
        this.first = false;
    }

    public void openObject() {
        try {
            this.writeCommaIfNeeded();
            this.writer.write("{");
        }
        catch (IOException e) {
            this.logger.error("Json writer exception", (Throwable)e);
        }
        this.first = true;
    }

    public void closeObject() {
        try {
            this.writer.write("}");
        }
        catch (IOException e) {
            this.logger.error("Json writer exception", (Throwable)e);
        }
        this.first = false;
    }

    public void writeKeyValue(String key, String value) {
        String rawValue = MessageFormat.format("\"{0}\"", StringEscapeUtils.escapeJava((String)value));
        this.writeKeyRawValue(key, rawValue);
    }

    public void writeKeyValue(String key, Integer intValue) {
        String rawValue = OgnlUtils.convertValueToString(intValue);
        this.writeKeyRawValue(key, rawValue);
    }

    public void writeKeyValue(String key, Boolean booleanValue) {
        String rawValue = booleanValue == null ? null : (booleanValue != false ? "true" : "false");
        this.writeKeyRawValue(key, rawValue);
    }

    protected void writeKeyRawValue(String key, String rawValue) {
        if (rawValue == null) {
            rawValue = "null";
        }
        try {
            this.writeCommaIfNeeded();
            String text = MessageFormat.format("\"{0}\":{1}", StringEscapeUtils.escapeJava((String)key), rawValue);
            this.writer.write(text);
        }
        catch (IOException e) {
            this.logger.error("Json writer exception", (Throwable)e);
        }
    }

    protected void writeCommaIfNeeded() throws IOException {
        if (this.first) {
            this.first = false;
        } else {
            this.writer.write(",");
        }
    }

    public String toString() {
        return this.writer.toString();
    }
}

