/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.Password;
import com.manydesigns.elements.fields.TextField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class PasswordField
extends TextField {
    public static final String copyright = "Copyright (C) 2005-2025 ManyDesigns srl";
    public static final String PASSWORD_PLACEHOLDER = "********";
    private String confirmationValue;
    private boolean confirmationRequired = false;

    public PasswordField(PropertyAccessor accessor, Mode mode) {
        this(accessor, mode, null);
        this.confirmationRequired = accessor.getAnnotation(Password.class).confirmationRequired();
    }

    public PasswordField(PropertyAccessor accessor, Mode mode, String prefix) {
        super(accessor, mode, prefix);
        this.confirmationRequired = accessor.getAnnotation(Password.class).confirmationRequired();
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        if (this.mode.isView(this.insertable, this.updatable)) {
            return;
        }
        String reqValue = req.getParameter(this.inputName);
        if (reqValue == null) {
            return;
        }
        this.stringValue = reqValue.trim();
        String confirmationInputName = this.inputName + "_confirm";
        reqValue = req.getParameter(confirmationInputName);
        if (reqValue == null) {
            return;
        }
        this.confirmationValue = reqValue.trim();
    }

    @Override
    public boolean validate() {
        if (this.mode.isView(this.insertable, this.updatable) || this.mode.isBulk() && !this.bulkChecked) {
            return true;
        }
        if (!super.validate()) {
            return false;
        }
        if (!this.confirmationRequired) {
            return true;
        }
        if (!StringUtils.equals((String)this.stringValue, (String)this.confirmationValue)) {
            this.errors.add(this.getText("elements.error.field.passwords.dont.match", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void readFromObject(Object obj) {
        super.readFromObject(obj);
        this.confirmationValue = this.stringValue;
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        if (this.mode.isEdit() && (this.mode.isCreate() || this.updatable)) {
            this.openVisibleField(xb);
            this.valueToXhtml(xb, this.id, this.inputName, this.stringValue);
            this.helpToXhtml(xb);
            if (this.confirmationRequired) {
                this.closeVisibleField(xb);
                xb.openElement("div");
                Object cssClass = "form-group readwrite required";
                if (this.errors.size() > 0) {
                    cssClass = (String)cssClass + " has-error";
                }
                xb.addAttribute("class", (String)cssClass);
                String confirmationHtmlId = this.id + "_confirm";
                String confirmationInputName = this.inputName + "_confirm";
                String confirmLabel = ElementsThreadLocals.getText("elements.field.password.confirm", new Object[0]) + " " + this.label;
                boolean capitalize = this.elementsConfiguration.getBoolean("fields.label.capitalize");
                Object actualLabel = capitalize ? StringUtils.capitalize((String)confirmLabel) : confirmLabel;
                xb.writeLabel((String)actualLabel, confirmationHtmlId, "control-label");
                xb.openElement("div");
                xb.addAttribute("class", "input-container " + this.fieldCssClass);
                this.valueToXhtml(xb, confirmationHtmlId, confirmationInputName, this.confirmationValue);
            }
            this.errorsToXhtml(xb);
            this.closeVisibleField(xb);
        } else {
            super.toXhtml(xb);
        }
    }

    @Override
    public void labelToXhtml(XhtmlBuffer xb) {
        this.labelToXhtml(xb, this.id, this.label);
    }

    public void labelToXhtml(XhtmlBuffer xb, String actualHtmlId, String actualLabel) {
        xb.openElement("label");
        xb.addAttribute("for", actualHtmlId);
        xb.addAttribute("class", "control-label");
        xb.write(StringUtils.capitalize((String)actualLabel));
        xb.closeElement("label");
    }

    @Override
    public void valueToXhtml(XhtmlBuffer xb) {
        this.valueToXhtml(xb, this.id, this.inputName, this.stringValue);
    }

    public void valueToXhtml(XhtmlBuffer xb, String actualHtmlId, String actualInputName, String actualStringValue) {
        if (this.mode.isView(this.insertable, this.updatable)) {
            this.valueToXhtmlView(xb);
        } else if (this.mode.isEdit()) {
            this.valueToXhtmlEdit(xb, actualHtmlId, actualInputName, actualStringValue);
        } else if (this.mode.isPreview()) {
            this.valueToXhtmlPreview(xb, actualInputName, actualStringValue);
        } else if (this.mode.isHidden()) {
            xb.writeInputHidden(actualInputName, actualStringValue);
        } else {
            throw new IllegalStateException("Unknown mode: " + this.mode);
        }
    }

    protected void valueToXhtmlPreview(XhtmlBuffer xb, String actualInputName, String actualStringValue) {
        this.valueToXhtmlView(xb);
        xb.writeInputHidden(actualInputName, actualStringValue);
    }

    @Override
    protected void valueToXhtmlView(XhtmlBuffer xb) {
        xb.openElement("p");
        xb.addAttribute("class", "form-control-static");
        xb.addAttribute("id", this.id);
        xb.write(PASSWORD_PLACEHOLDER);
        xb.closeElement("p");
    }

    protected void valueToXhtmlEdit(XhtmlBuffer xb, String actualHtmlId, String actualInputName, String actualStringValue) {
        xb.openElement("input");
        xb.addAttribute("type", "password");
        xb.addAttribute("class", "form-control");
        xb.addAttribute("id", actualHtmlId);
        xb.addAttribute("name", actualInputName);
        xb.addAttribute("value", actualStringValue);
        if (this.maxLength != null) {
            int textInputSize = this.size != null && this.maxLength > this.size ? this.size : this.maxLength;
            xb.addAttribute("maxlength", Integer.toString(this.maxLength));
            xb.addAttribute("size", Integer.toString(textInputSize));
        }
        xb.closeElement("input");
    }

    public String getConfirmationValue() {
        return this.confirmationValue;
    }

    public void setConfirmationValue(String confirmationValue) {
        this.confirmationValue = confirmationValue;
    }

    public boolean isConfirmationRequired() {
        return this.confirmationRequired;
    }

    public void setConfirmationRequired(boolean confirmationRequired) {
        this.confirmationRequired = confirmationRequired;
    }
}

