/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.options;

import com.manydesigns.elements.options.DisplayMode;
import com.manydesigns.elements.options.OptionProvider;
import com.manydesigns.elements.options.SearchDisplayMode;
import com.manydesigns.elements.options.SelectionModel;
import com.manydesigns.elements.options.SelectionProvider;
import com.manydesigns.elements.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSelectionProvider
implements SelectionProvider {
    public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
    public static final Comparator<OptionProvider.Option> OPTION_COMPARATOR_BY_LABEL = (r1, r2) -> {
        for (int i = 0; i < r1.labels.length; ++i) {
            int comp = Util.compare(r1.getLabels()[i], r2.getLabels()[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    };
    protected final String name;
    protected final int fieldCount;
    protected final OptionProvider optionProvider;
    protected DisplayMode displayMode;
    protected SearchDisplayMode searchDisplayMode;
    protected String createNewValueHref;
    protected String createNewValueText;
    public static final Logger logger = LoggerFactory.getLogger(DefaultSelectionProvider.class);
    public static final String NON_WORD_CHARACTERS = " \t\n\f\r\\||!\"\u00ac\u00a3$\u201a\u00c7\u00a8%&/()='?^[]+*@#<>,;.:-_";

    public DefaultSelectionProvider(String name, int fieldCount, OptionProvider optionProvider) {
        this.name = name;
        this.fieldCount = fieldCount;
        this.optionProvider = optionProvider;
    }

    public DefaultSelectionProvider(String name, int fieldCount, OptionProvider.Option[] options) {
        this(name, fieldCount, new ArrayList<OptionProvider.Option>(Arrays.asList(options)));
    }

    public DefaultSelectionProvider(String name, int fieldCount, List<OptionProvider.Option> options) {
        this(name, fieldCount, new StaticOptionProvider(options));
    }

    public DefaultSelectionProvider(String name, int fieldCount) {
        this(name, fieldCount, new OptionProvider.Option[0]);
    }

    public DefaultSelectionProvider(String name) {
        this(name, 1);
    }

    public DefaultSelectionProvider(DefaultSelectionProvider copy) {
        this(copy.getName(), copy.getFieldCount(), copy.optionProvider);
    }

    public List<OptionProvider.Option> getOptions() {
        return this.optionProvider.getOptions();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    @Override
    public SelectionModel createSelectionModel() {
        return new DefaultSelectionModel();
    }

    @Deprecated
    public void appendRow(OptionProvider.Option option) {
        this.appendOption(option);
    }

    public void appendOption(OptionProvider.Option option) {
        if (option.values.length != this.fieldCount) {
            throw new IllegalArgumentException("Field count mismatch");
        }
        this.getOptions().add(option);
    }

    @Deprecated
    public void appendRow(Object[] values, String[] labels, boolean active) {
        this.appendOption(values, labels, active);
    }

    public void appendOption(Object[] values, String[] labels, boolean active) {
        OptionProvider.Option option = new OptionProvider.Option(values, labels, active);
        this.appendOption(option);
    }

    @Deprecated
    public void appendRow(Object value, String label, boolean active) {
        this.appendOption(value, label, active);
    }

    public void appendOption(Object value, String label, boolean active) {
        this.appendOption(new Object[]{value}, new String[]{label}, active);
    }

    @Override
    public void ensureActive(Object ... values) {
        OptionProvider.Option option = null;
        ListIterator<OptionProvider.Option> iterator = this.getOptions().listIterator();
        while (iterator.hasNext()) {
            OptionProvider.Option current = iterator.next();
            boolean found = true;
            for (int i = 0; i < this.fieldCount; ++i) {
                if (ObjectUtils.equals((Object)values[i], (Object)current.getValues()[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            option = new OptionProvider.Option(values, current.getLabels(), true);
            iterator.set(option);
            break;
        }
        if (option == null) {
            String[] labels = new String[this.fieldCount];
            for (int i = 0; i < this.fieldCount; ++i) {
                labels[i] = ObjectUtils.toString((Object)values[i]);
            }
            option = new OptionProvider.Option(values, labels, true);
            this.getOptions().add(option);
        }
    }

    public void sortByLabel() {
        this.getOptions().sort(OPTION_COMPARATOR_BY_LABEL);
    }

    private boolean matchLabel(String cellLabel, String labelSearch) {
        if (labelSearch == null || labelSearch.length() == 0) {
            return true;
        }
        cellLabel = cellLabel.toLowerCase();
        labelSearch = labelSearch.toLowerCase();
        String[] cellLabelArray = StringUtils.split((String)cellLabel, (String)NON_WORD_CHARACTERS);
        String[] searchLabelArray = StringUtils.split((String)labelSearch, (String)NON_WORD_CHARACTERS);
        for (int i = 0; i <= cellLabelArray.length - searchLabelArray.length; ++i) {
            boolean allMatch = true;
            for (int j = 0; j < searchLabelArray.length; ++j) {
                allMatch &= cellLabelArray[i + j].startsWith(searchLabelArray[j]);
            }
            if (!allMatch) continue;
            return true;
        }
        return false;
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    @Override
    public SearchDisplayMode getSearchDisplayMode() {
        return this.searchDisplayMode;
    }

    public void setSearchDisplayMode(SearchDisplayMode searchDisplayMode) {
        this.searchDisplayMode = searchDisplayMode;
    }

    @Override
    public String getCreateNewValueHref() {
        return this.createNewValueHref;
    }

    public void setCreateNewValueHref(String createNewValueHref) {
        this.createNewValueHref = createNewValueHref;
    }

    @Override
    public String getCreateNewValueText() {
        return this.createNewValueText;
    }

    public void setCreateNewValueText(String createNewValueText) {
        this.createNewValueText = createNewValueText;
    }

    class DefaultSelectionModel
    implements SelectionModel {
        public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
        private final Object[] values;
        private final String[] labelSearches;
        private final Map<Object, SelectionModel.Option>[] optionsArray;
        private boolean needsValidation;

        public DefaultSelectionModel() {
            this.values = new Object[DefaultSelectionProvider.this.fieldCount];
            this.labelSearches = new String[DefaultSelectionProvider.this.fieldCount];
            this.optionsArray = new Map[DefaultSelectionProvider.this.fieldCount];
            for (int i = 0; i < DefaultSelectionProvider.this.fieldCount; ++i) {
                this.optionsArray[i] = new LinkedHashMap<Object, SelectionModel.Option>();
            }
            this.needsValidation = true;
        }

        @Override
        public SelectionProvider getSelectionProvider() {
            return DefaultSelectionProvider.this;
        }

        @Override
        public String getName() {
            return DefaultSelectionProvider.this.name;
        }

        @Override
        public Object getValue(int index) {
            if (this.values[index] != null) {
                this.validate();
            }
            return this.values[index];
        }

        @Override
        public void setValue(int index, Object value) {
            Object previousValue = this.values[index];
            this.values[index] = value;
            this.needsValidation = this.needsValidation || !Objects.equals(previousValue, value);
        }

        @Override
        public void setLabelSearch(int index, String labelSearch) {
            this.labelSearches[index] = labelSearch;
            this.needsValidation = true;
        }

        @Override
        public String getLabelSearch(int index) {
            return this.labelSearches[index];
        }

        @Override
        public Map<Object, SelectionModel.Option> getOptions(int index) {
            this.validate();
            return this.optionsArray[index];
        }

        @Override
        public String getOption(int index, Object value, boolean includeInactive) {
            Map<Object, SelectionModel.Option> options = this.getOptions(index);
            SelectionModel.Option option = options.get(value);
            if (option != null && (option.active || includeInactive)) {
                return option.label;
            }
            return null;
        }

        private void validate() {
            if (!this.needsValidation) {
                return;
            }
            this.needsValidation = false;
            boolean foundNull = false;
            for (int j = 0; j < DefaultSelectionProvider.this.fieldCount; ++j) {
                if (foundNull) {
                    this.values[j] = null;
                } else if (this.values[j] == null) {
                    foundNull = true;
                }
                this.optionsArray[j].clear();
            }
            int maxMatchingIndex = -1;
            block1: for (OptionProvider.Option option : DefaultSelectionProvider.this.getOptions()) {
                Object[] currentValueRow = option.getValues();
                String[] currentLabelRow = option.getLabels();
                for (int j = 0; j < DefaultSelectionProvider.this.fieldCount; ++j) {
                    SelectionModel.Option currentOption;
                    Object cellValue = currentValueRow[j];
                    String cellLabel = currentLabelRow[j];
                    Object value = this.values[j];
                    String labelSearch = this.labelSearches[j];
                    if (cellLabel != null && DefaultSelectionProvider.this.matchLabel(cellLabel, labelSearch) && ((currentOption = this.optionsArray[j].get(cellValue)) == null || !currentOption.active)) {
                        this.optionsArray[j].put(cellValue, new SelectionModel.Option(cellValue, cellLabel, option.isActive()));
                    }
                    if (value != null && value.equals(cellValue)) {
                        if (j <= maxMatchingIndex) continue;
                        maxMatchingIndex = j;
                        continue;
                    }
                    if (!(value instanceof Object[]) || !ArrayUtils.contains((Object[])((Object[])value), (Object)cellValue)) continue block1;
                    if (j <= maxMatchingIndex) continue;
                    maxMatchingIndex = j;
                }
            }
            for (int i = maxMatchingIndex + 1; i < DefaultSelectionProvider.this.fieldCount; ++i) {
                this.values[i] = null;
            }
        }
    }

    private static class StaticOptionProvider
    implements OptionProvider {
        private final List<OptionProvider.Option> options;

        public StaticOptionProvider(List<OptionProvider.Option> options) {
            this.options = options;
        }

        @Override
        public List<OptionProvider.Option> getOptions() {
            return this.options;
        }
    }
}

