/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.search;

import com.manydesigns.elements.fields.search.Criteria;
import com.manydesigns.elements.fields.search.Criterion;
import com.manydesigns.elements.fields.search.TextMatchMode;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class BaseCriteria
extends ArrayList<Criterion>
implements Criteria {
    public static final String copyright = "Copyright (C) 2005-2024 ManyDesigns srl";
    protected Criteria.OrderBy orderBy;

    @Override
    public Criteria eq(PropertyAccessor accessor, Object value) {
        this.add(new EqCriterion(accessor, value));
        return this;
    }

    @Override
    public Criteria in(PropertyAccessor accessor, Object[] values) {
        this.add(new InCriterion(accessor, values));
        return this;
    }

    @Override
    public Criteria ne(PropertyAccessor accessor, Object value) {
        this.add(new NeCriterion(accessor, value));
        return this;
    }

    @Override
    public Criteria between(PropertyAccessor accessor, Object min, Object max) {
        this.add(new BetweenCriterion(accessor, min, max));
        return this;
    }

    @Override
    public Criteria gt(PropertyAccessor accessor, Object value) {
        this.add(new GtCriterion(accessor, value));
        return this;
    }

    @Override
    public Criteria ge(PropertyAccessor accessor, Object value) {
        this.add(new GeCriterion(accessor, value));
        return this;
    }

    @Override
    public Criteria lt(PropertyAccessor accessor, Object value) {
        this.add(new LtCriterion(accessor, value));
        return this;
    }

    @Override
    public Criteria le(PropertyAccessor accessor, Object value) {
        this.add(new LeCriterion(accessor, value));
        return this;
    }

    @Override
    public Criteria like(PropertyAccessor accessor, String value, TextMatchMode textMatchMode) {
        this.add(new LikeCriterion(accessor, value, textMatchMode));
        return this;
    }

    @Override
    public Criteria ilike(PropertyAccessor accessor, String value, TextMatchMode textMatchMode) {
        this.add(new IlikeCriterion(accessor, value, textMatchMode));
        return this;
    }

    @Override
    public Criteria isNull(PropertyAccessor accessor) {
        this.add(new IsNullCriterion(accessor));
        return this;
    }

    @Override
    public Criteria isNotNull(PropertyAccessor accessor) {
        this.add(new IsNotNullCriterion(accessor));
        return this;
    }

    @Override
    public Criteria orderBy(PropertyAccessor accessor, String direction) {
        this.orderBy = new Criteria.OrderBy(accessor, direction);
        return this;
    }

    @Override
    public Criteria.OrderBy getOrderBy() {
        return this.orderBy;
    }

    public static class IsNotNullCriterion
    extends AbstractCriterion {
        public IsNotNullCriterion(PropertyAccessor accessor) {
            super(accessor);
        }
    }

    public static class IsNullCriterion
    extends AbstractCriterion {
        public IsNullCriterion(PropertyAccessor accessor) {
            super(accessor);
        }
    }

    public static class IlikeCriterion
    extends AbstractCriterion {
        protected final Object value;
        protected final TextMatchMode textMatchMode;

        public IlikeCriterion(PropertyAccessor accessor, Object value, TextMatchMode textMatchMode) {
            super(accessor);
            this.value = value;
            this.textMatchMode = textMatchMode;
        }

        public Object getValue() {
            return this.value;
        }

        public TextMatchMode getTextMatchMode() {
            return this.textMatchMode;
        }
    }

    public static class LikeCriterion
    extends AbstractCriterion {
        protected final Object value;
        protected final TextMatchMode textMatchMode;

        public LikeCriterion(PropertyAccessor accessor, Object value, TextMatchMode textMatchMode) {
            super(accessor);
            this.value = value;
            this.textMatchMode = textMatchMode;
        }

        public Object getValue() {
            return this.value;
        }

        public TextMatchMode getTextMatchMode() {
            return this.textMatchMode;
        }
    }

    public static class LeCriterion
    extends AbstractCriterion {
        protected final Object value;

        public LeCriterion(PropertyAccessor accessor, Object value) {
            super(accessor);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class LtCriterion
    extends AbstractCriterion {
        protected final Object value;

        public LtCriterion(PropertyAccessor accessor, Object value) {
            super(accessor);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class GeCriterion
    extends AbstractCriterion {
        protected final Object value;

        public GeCriterion(PropertyAccessor accessor, Object value) {
            super(accessor);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class GtCriterion
    extends AbstractCriterion {
        protected final Object value;

        public GtCriterion(PropertyAccessor accessor, Object value) {
            super(accessor);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class BetweenCriterion
    extends AbstractCriterion {
        protected final Object min;
        protected final Object max;

        public BetweenCriterion(PropertyAccessor accessor, Object min, Object max) {
            super(accessor);
            this.min = min;
            this.max = max;
        }

        public Object getMin() {
            return this.min;
        }

        public Object getMax() {
            return this.max;
        }
    }

    public static class NeCriterion
    extends AbstractCriterion {
        protected final Object value;

        public NeCriterion(@NotNull PropertyAccessor accessor, @NotNull Object value) {
            super(accessor);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class InCriterion
    extends AbstractCriterion {
        protected final Object[] values;

        public InCriterion(@NotNull PropertyAccessor accessor, @NotNull Object[] values) {
            super(accessor);
            this.values = values;
            for (Object value : values) {
                if (value != null) continue;
                throw new IllegalArgumentException("Null value");
            }
        }

        public Object[] getValues() {
            return this.values;
        }
    }

    public static class EqCriterion
    extends AbstractCriterion {
        protected final Object value;

        public EqCriterion(@NotNull PropertyAccessor accessor, @NotNull Object value) {
            super(accessor);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static abstract class AbstractCriterion
    implements Criterion {
        protected final PropertyAccessor accessor;

        public AbstractCriterion(PropertyAccessor accessor) {
            this.accessor = accessor;
        }

        @Override
        public PropertyAccessor getPropertyAccessor() {
            return this.accessor;
        }
    }
}

