/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.ognl;

import com.manydesigns.elements.ElementsThreadLocals;
import java.lang.reflect.Field;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgnlUtils {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(OgnlUtils.class);

    public static Object getValueQuietly(String expression, Map ognlContext, Object root) {
        Object parsedOgnlExpression = OgnlUtils.parseExpressionQuietly(expression);
        return OgnlUtils.getValueQuietly(parsedOgnlExpression, ognlContext, root);
    }

    public static Object parseExpressionQuietly(String expression) {
        Object result;
        if (expression == null) {
            logger.warn("Null expression");
            return null;
        }
        try {
            result = Ognl.parseExpression((String)expression);
        }
        catch (OgnlException e) {
            result = null;
            logger.warn("Error during parsing of ognl expression: " + expression, (Throwable)e);
        }
        return result;
    }

    public static Object getValueQuietly(Object parsedExpression, Map ognlContext, Object root) {
        Object result;
        if (parsedExpression == null) {
            logger.warn("Null parsed expression");
            return null;
        }
        try {
            result = ognlContext == null ? Ognl.getValue((Object)parsedExpression, (Object)root) : Ognl.getValue((Object)parsedExpression, (Map)ognlContext, (Object)root);
        }
        catch (OgnlException e) {
            result = null;
            logger.debug("Error during evaluation of ognl expression: " + parsedExpression.toString(), (Throwable)e);
        }
        return result;
    }

    public static String convertValueToString(Object value) {
        return OgnlUtils.convertValue(value, String.class);
    }

    public static <T> T convertValue(Object value, Class<T> toType) {
        OgnlContext ognlContext = ElementsThreadLocals.getOgnlContext();
        TypeConverter typeConverter = ognlContext.getTypeConverter();
        return (T)typeConverter.convertValue((Map)ognlContext, null, null, null, value, toType);
    }

    public static <T> T convertValueQuietly(Object value, Class<T> toType) {
        try {
            return OgnlUtils.convertValue(value, toType);
        }
        catch (Throwable e) {
            logger.debug("Error during conversion of value: " + value, e);
            return null;
        }
    }

    public static void clearCache() {
        OgnlRuntime.clearCache();
        OgnlUtils.clearOGNLCache("cacheGetMethod");
        OgnlUtils.clearOGNLCache("cacheSetMethod");
    }

    protected static void clearOGNLCache(String fieldName) {
        try {
            Field field = OgnlRuntime.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object ognlCache = field.get(null);
            Field cacheField = ognlCache.getClass().getDeclaredField("cache");
            cacheField.setAccessible(true);
            Map cache = (Map)cacheField.get(ognlCache);
            cache.clear();
        }
        catch (Exception e) {
            logger.warn("Could not clear OGNL cache " + fieldName, (Throwable)e);
        }
    }
}

