/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.forms;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.Enabled;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.fields.SelectField;
import com.manydesigns.elements.fields.helpers.FieldsManager;
import com.manydesigns.elements.options.SelectionProvider;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFormBuilder {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    protected final FieldsManager manager;
    protected final ClassAccessor classAccessor;
    protected final Map<String[], SelectionProvider> selectionProviders;
    protected String prefix;
    protected Mode mode = Mode.EDIT;
    public static final Logger logger = LoggerFactory.getLogger(AbstractFormBuilder.class);

    public AbstractFormBuilder(ClassAccessor classAccessor) {
        logger.debug("Entering AbstractBuilder constructor");
        this.manager = FieldsManager.getManager();
        this.classAccessor = classAccessor;
        this.selectionProviders = new HashMap<String[], SelectionProvider>();
        logger.debug("Exiting AbstractBuilder constructor");
    }

    protected void removeUnusedSelectionProviders(Collection<PropertyAccessor> propertyAccessors) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (PropertyAccessor propertyAccessor : propertyAccessors) {
            propertyNames.add(propertyAccessor.getName());
        }
        ArrayList<String[]> removeList = new ArrayList<String[]>();
        for (String[] current : this.selectionProviders.keySet()) {
            List<String> currentNames = Arrays.asList(current);
            if (propertyNames.containsAll(currentNames)) continue;
            removeList.add(current);
        }
        for (String[] current : removeList) {
            this.selectionProviders.remove(current);
        }
    }

    protected boolean isPropertyEnabled(PropertyAccessor propertyAccessor) {
        Enabled enabled = propertyAccessor.getAnnotation(Enabled.class);
        if (enabled != null && !enabled.value()) {
            logger.debug("Skipping non-enabled field: {}", (Object)propertyAccessor.getName());
            return false;
        }
        return true;
    }

    protected Field buildField(PropertyAccessor propertyAccessor, Field field, String prefix) {
        if (field == null) {
            field = this.manager.tryToInstantiateField(this.classAccessor, propertyAccessor, this.mode, prefix);
        }
        if (field == null) {
            logger.warn("Cannot instantiate field for property {}", (Object)propertyAccessor);
        }
        return field;
    }

    protected SelectField buildSelectField(PropertyAccessor propertyAccessor, SelectionProvider selectionProvider, String prefix) {
        return new SelectField(propertyAccessor, selectionProvider, this.mode, prefix);
    }
}

